<?php
/**
 * Layout options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add layout section
$wp_customize->add_section( 'personify_pro_menu', array(
	'title'               => esc_html__('Primary Menu','personify-pro'),
	'description'         => esc_html__( 'Primary Menu options', 'personify-pro' ),
	'panel'               => 'personify_pro_theme_options_panel',
) );

// Menu sticky setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[menu_sticky]', array(
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
	'default'             => $options['menu_sticky'],
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[menu_sticky]', array(
	'label'               => esc_html__( 'Make Primary Menu Sticky', 'personify-pro' ),
	'section'             => 'personify_pro_menu',
	'on_off_label' 		=> array(
		'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
		'off' 		=> esc_html__( 'No', 'personify-pro' )
	)
) ) );

// Menu sticky setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[menu_label_enable]', array(
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
	'default'             => $options['menu_label_enable'],
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[menu_label_enable]', array(
	'label'               => esc_html__( 'Show Primary Menu Label in Responsive View', 'personify-pro' ),
	'description'         => esc_html__( 'It is shown on the side of Bar icon for menu access in responsive view.', 'personify-pro' ),
	'section'             => 'personify_pro_menu',
	'on_off_label' 		=> array(
		'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
		'off' 		=> esc_html__( 'No', 'personify-pro' )
	)
) ) );
