<?php
/**
 * pagination options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add sidebar section
$wp_customize->add_section( 'personify_pro_pagination', array(
	'title'               	=> esc_html__('Pagination','personify-pro'),
	'description'         	=> esc_html__( 'Pagination section options.', 'personify-pro' ),
	'panel'               	=> 'personify_pro_theme_options_panel',
) );

// Sidebar position setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[pagination_enable]', array(
	'sanitize_callback' 	=> 'personify_pro_sanitize_switch_control',
	'default'             	=> $options['pagination_enable'],
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[pagination_enable]', array(
	'label'               	=> esc_html__( 'Pagination Enable', 'personify-pro' ),
	'description'           => esc_html__( 'Note: This pagination option is for blog, archive and search page.', 'personify-pro' ),
	'section'             	=> 'personify_pro_pagination',
	'on_off_label' 			=> personify_pro_enable_options(),
) ) );

// Site layout setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[pagination_type]', array(
	'sanitize_callback'   => 'personify_pro_sanitize_select',
	'default'             => $options['pagination_type'],
) );

$wp_customize->add_control( 'personify_pro_theme_options[pagination_type]', array(
	'label'               => esc_html__( 'Pagination Type', 'personify-pro' ),
	'section'             => 'personify_pro_pagination',
	'type'                => 'select',
	'choices'			  => personify_pro_pagination_options(),
	'active_callback'	  => 'personify_pro_is_pagination_enable',
) );
