<?php
/**
 * Reset options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

/**
* Reset section
*/
// Add reset enable section
$wp_customize->add_section( 'personify_pro_reset_section', array(
	'title'             => esc_html__('Reset all settings','personify-pro'),
	'description'       => esc_html__( 'Caution: All settings will be reset to default. Refresh the page after clicking Save & Publish.', 'personify-pro' ),
) );

// Add reset enable setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[reset_options]', array(
	'default'           => $options['reset_options'],
	'sanitize_callback' => 'personify_pro_sanitize_checkbox',
	'transport'			  => 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[reset_options]', array(
	'label'             => esc_html__( 'Check to reset all settings', 'personify-pro' ),
	'section'           => 'personify_pro_reset_section',
	'type'              => 'checkbox',
) );
