<?php
/**
 * Excerpt options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add excerpt section
$wp_customize->add_section( 'personify_pro_single_post_section', array(
	'title'             => esc_html__( 'Single Post/Page','personify-pro' ),
	'description'       => esc_html__( 'Options to change the single posts/pages globally.', 'personify-pro' ),
	'panel'             => 'personify_pro_theme_options_panel',
) );

// Archive date meta setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[single_post_show_date]', array(
	'default'           => $options['single_post_show_date'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[single_post_show_date]', array(
	'label'             => esc_html__( 'Show Date', 'personify-pro' ),
	'section'           => 'personify_pro_single_post_section',
	'on_off_label' 		=> array(
		'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
		'off' 		=> esc_html__( 'No', 'personify-pro' )
	)
) ) );

// Archive author meta setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[single_post_show_author]', array(
	'default'           => $options['single_post_show_author'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[single_post_show_author]', array(
	'label'             => esc_html__( 'Show Author', 'personify-pro' ),
	'section'           => 'personify_pro_single_post_section',
	'on_off_label' 		=> array(
		'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
		'off' 		=> esc_html__( 'No', 'personify-pro' )
	)
) ) );

// Single pagination setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[single_post_show_pagination]', array(
	'default'           => $options['single_post_show_pagination'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[single_post_show_pagination]', array(
	'label'             => esc_html__( 'Show Pagination', 'personify-pro' ),
	'section'           => 'personify_pro_single_post_section',
	'on_off_label' 		=> array(
		'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
		'off' 		=> esc_html__( 'No', 'personify-pro' )
	)
) ) );

// Archive author category setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[single_post_show_category]', array(
	'default'           => $options['single_post_show_category'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[single_post_show_category]', array(
	'label'             => esc_html__( 'Show Category', 'personify-pro' ),
	'section'           => 'personify_pro_single_post_section',
	'on_off_label' 		=> array(
		'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
		'off' 		=> esc_html__( 'No', 'personify-pro' )
	)
) ) );

// Archive tag category setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[single_post_show_tags]', array(
	'default'           => $options['single_post_show_tags'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[single_post_show_tags]', array(
	'label'             => esc_html__( 'Show Tag', 'personify-pro' ),
	'section'           => 'personify_pro_single_post_section',
	'on_off_label' 		=> array(
		'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
		'off' 		=> esc_html__( 'No', 'personify-pro' )
	)
) ) );

// Archive tag category setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[single_post_show_comments]', array(
	'default'           => $options['single_post_show_comments'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[single_post_show_comments]', array(
	'label'             => esc_html__( 'Show Comments Meta', 'personify-pro' ),
	'section'           => 'personify_pro_single_post_section',
	'on_off_label' 		=> array(
		'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
		'off' 		=> esc_html__( 'No', 'personify-pro' )
	)
) ) );

// Related Posts setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[single_post_show_related]', array(
	'default'           => $options['single_post_show_related'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[single_post_show_related]', array(
	'label'             => esc_html__( 'Show Related Posts', 'personify-pro' ),
	'section'           => 'personify_pro_single_post_section',
	'on_off_label' 		=> array(
		'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
		'off' 		=> esc_html__( 'No', 'personify-pro' )
	)
) ) );

// Social share setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[single_post_show_social]', array(
	'default'           => $options['single_post_show_social'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[single_post_show_social]', array(
	'label'             => esc_html__( 'Enable Social Share', 'personify-pro' ),
	'section'           => 'personify_pro_single_post_section',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );

// Facebook Social share setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[single_post_show_facebook]', array(
	'sanitize_callback'	=> 'personify_pro_sanitize_checkbox',
	'default'          	=> $options['single_post_show_facebook']
) );

$wp_customize->add_control( 'personify_pro_theme_options[single_post_show_facebook]', array(
	'label'             => esc_html__( 'Facebook Share', 'personify-pro' ),
	'section'          	=> 'personify_pro_single_post_section',
	'active_callback'   => 'personify_pro_is_single_social_share_enable',
	'type'             	=> 'checkbox',
) );

// Twitter Social share setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[single_post_show_twitter]', array(
	'sanitize_callback'	=> 'personify_pro_sanitize_checkbox',
	'default'          	=> $options['single_post_show_twitter']
) );

$wp_customize->add_control( 'personify_pro_theme_options[single_post_show_twitter]', array(
	'label'             => esc_html__( 'Twitter Share', 'personify-pro' ),
	'section'          	=> 'personify_pro_single_post_section',
	'active_callback'   => 'personify_pro_is_single_social_share_enable',
	'type'             	=> 'checkbox',
) );


// Google Plus Social share setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[single_post_show_google]', array(
	'sanitize_callback'	=> 'personify_pro_sanitize_checkbox',
	'default'          	=> $options['single_post_show_google']
) );

$wp_customize->add_control( 'personify_pro_theme_options[single_post_show_google]', array(
	'label'             => esc_html__( 'Google Plus Share', 'personify-pro' ),
	'section'          	=> 'personify_pro_single_post_section',
	'active_callback'   => 'personify_pro_is_single_social_share_enable',
	'type'             	=> 'checkbox',
) );