<?php
/**
 * Typography options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Typography Section
$wp_customize->add_section( 'personify_pro_section_typography',
	array(
		'title'      		=> esc_html__( 'Typography', 'personify-pro' ),
		'priority'   		=> 600,
		'panel'      		=> 'personify_pro_theme_options_panel',
	)
);

$wp_customize->add_setting( 'personify_pro_theme_options[theme_typography]',
	array(
		'default'    		=> $options['theme_typography'],
		'sanitize_callback'	=> 'personify_pro_sanitize_select',
	)
);
$wp_customize->add_control( 'personify_pro_theme_options[theme_typography]',
    array(
		'label'       		=> esc_html__( 'Choose Heading Typography', 'personify-pro' ),
		'section'     		=> 'personify_pro_section_typography',
		'settings'    		=> 'personify_pro_theme_options[theme_typography]',
		'type'		  		=> 'select',
		'choices'			=> personify_pro_typography_options(),
    )
);

$wp_customize->add_setting( 'personify_pro_theme_options[body_theme_typography]',
	array(
		'default'    		=> $options['body_theme_typography'],
		'sanitize_callback'	=> 'personify_pro_sanitize_select',
	)
);
$wp_customize->add_control( 'personify_pro_theme_options[body_theme_typography]',
    array(
		'label'       		=> esc_html__( 'Choose Body Typography', 'personify-pro' ),
		'section'     		=> 'personify_pro_section_typography',
		'settings'    		=> 'personify_pro_theme_options[body_theme_typography]',
		'type'		  		=> 'select',
		'choices'			=> personify_pro_body_typography_options(),
    )
);
