<?php
/**
* Customizer validation functions
*
* @package Theme Palace
* @subpackage Personify Pro
* @since Personify Pro 1.0
*/

if ( ! function_exists( 'personify_pro_validate_long_excerpt' ) ) :
    function personify_pro_validate_long_excerpt( $validity, $value ){
        $value = intval( $value );
        if ( empty( $value ) || ! is_numeric( $value ) ) {
            $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'personify-pro' ) );
        } elseif ( $value < 5 ) {
            $validity->add( 'min_no_of_words', esc_html__( 'Minimum no of words is 5', 'personify-pro' ) );
        } elseif ( $value > 100 ) {
            $validity->add( 'max_no_of_words', esc_html__( 'Maximum no of words is 100', 'personify-pro' ) );
        }
        return $validity;
    }
endif;

if ( ! function_exists( 'personify_pro_validate_post_id' ) ) :
    function personify_pro_validate_post_id( $validity, $value ){
        $value = intval( $value );
        if ( empty( $value ) || ! is_numeric( $value ) ) {
            $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'personify-pro' ) );
        } elseif ( $value < 1 ) {
            $validity->add( 'min_value', esc_html__( 'Minimum value is 1', 'personify-pro' ) );
        } 
        return $validity;
    }
endif;

if ( ! function_exists( 'personify_pro_validate_no_of_quotation' ) ) :
    function personify_pro_validate_no_of_quotation( $validity, $value ){
        $value = intval( $value );
        if ( empty( $value ) || ! is_numeric( $value ) ) {
            $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'personify-pro' ) );
        } elseif ( $value < 1 ) {
            $validity->add( 'min_no_of_quotation', esc_html__( 'Minimum no of Quotation is 1', 'personify-pro' ) );
        } elseif ( $value > 5 ) {
            $validity->add( 'max_no_of_quotation', esc_html__( 'Maximum no of Quotation is 5', 'personify-pro' ) );
        }
        return $validity;
    }
endif;

if ( ! function_exists( 'personify_pro_validate_no_of_event' ) ) :
    function personify_pro_validate_no_of_event( $validity, $value ){
        $value = intval( $value );
        if ( empty( $value ) || ! is_numeric( $value ) ) {
            $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'personify-pro' ) );
        } elseif ( $value < 5 ) {
            $validity->add( 'min_no_of_event', esc_html__( 'Minimum no of Events is 5', 'personify-pro' ) );
        } elseif ( $value > 10 ) {
            $validity->add( 'max_no_of_event', esc_html__( 'Maximum no of Events is 10', 'personify-pro' ) );
        }
        return $validity;
    }
endif;

if ( ! function_exists( 'personify_pro_validate_no_of_event_social' ) ) :
    function personify_pro_validate_no_of_event_social( $validity, $value ){
        $value = intval( $value );
        if ( empty( $value ) || ! is_numeric( $value ) ) {
            $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'personify-pro' ) );
        } elseif ( $value < 1 ) {
            $validity->add( 'min_no_of_event_social', esc_html__( 'Minimum no of Social Links is 1', 'personify-pro' ) );
        } elseif ( $value > 5 ) {
            $validity->add( 'max_no_of_event_social', esc_html__( 'Maximum no of Social Links is 5', 'personify-pro' ) );
        }
        return $validity;
    }
endif;

if ( ! function_exists( 'personify_pro_validate_no_of_testimonial' ) ) :
    function personify_pro_validate_no_of_testimonial( $validity, $value ){
        $value = intval( $value );
        if ( empty( $value ) || ! is_numeric( $value ) ) {
            $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'personify-pro' ) );
        } elseif ( $value < 1 ) {
            $validity->add( 'min_no_of_testimonial', esc_html__( 'Minimum no of Testimonial is 1', 'personify-pro' ) );
        } elseif ( $value > 5 ) {
            $validity->add( 'max_no_of_testimonial', esc_html__( 'Maximum no of Testimonial is 5', 'personify-pro' ) );
        }
        return $validity;
    }
endif;

/* Custom Template */

if ( ! function_exists( 'personify_pro_validate_no_of_skills' ) ) :
    function personify_pro_validate_no_of_skills( $validity, $value ){
        $value = intval( $value );
        if ( empty( $value ) || ! is_numeric( $value ) ) {
            $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'personify-pro' ) );
        } elseif ( $value < 1 ) {
            $validity->add( 'min_no_of_skills', esc_html__( 'Minimum no of Skills is 1', 'personify-pro' ) );
        } elseif ( $value > 5 ) {
            $validity->add( 'max_no_of_skills', esc_html__( 'Maximum no of Skills is 5', 'personify-pro' ) );
        }
        return $validity;
    }
endif;

if ( ! function_exists( 'personify_pro_validate_no_of_portfolio' ) ) :
    function personify_pro_validate_no_of_portfolio( $validity, $value ){
        $value = intval( $value );
        if ( empty( $value ) || ! is_numeric( $value ) ) {
            $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'personify-pro' ) );
        } elseif ( $value < 1 ) {
            $validity->add( 'min_no_of_portfolio', esc_html__( 'Minimum no of portfolio is 1', 'personify-pro' ) );
        } elseif ( $value > 10 ) {
            $validity->add( 'max_no_of_portfolio', esc_html__( 'Maximum no of portfolio is 10', 'personify-pro' ) );
        }
        return $validity;
    }
endif;

if ( ! function_exists( 'personify_pro_validate_no_of_event_page' ) ) :
    function personify_pro_validate_no_of_event_page( $validity, $value ){
        $value = intval( $value );
        if ( empty( $value ) || ! is_numeric( $value ) ) {
            $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'personify-pro' ) );
        } elseif ( $value < 1 ) {
            $validity->add( 'min_no_of_event', esc_html__( 'Minimum no of Event is 1', 'personify-pro' ) );
        } elseif ( $value > 25 ) {
            $validity->add( 'max_no_of_event', esc_html__( 'Maximum no of Event is 25', 'personify-pro' ) );
        }
        return $validity;
    }
endif;

if ( ! function_exists( 'personify_pro_validate_no_of_feeds' ) ) :
    function personify_pro_validate_no_of_feeds( $validity, $value ){
        $value = intval( $value );
        if ( empty( $value ) || ! is_numeric( $value ) ) {
            $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'personify-pro' ) );
        } elseif ( $value < 3 ) {
            $validity->add( 'min_no_of_feeds', esc_html__( 'Minimum no of Feeds is 3', 'personify-pro' ) );
        } elseif ( $value > 10 ) {
            $validity->add( 'max_no_of_feeds', esc_html__( 'Maximum no of Feeds is 10', 'personify-pro' ) );
        }
        return $validity;
    }
endif;