<?php
/**
 * Custom functions that act independently of the theme templates.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function personify_pro_body_classes( $classes ) {
	$options = personify_pro_get_theme_options();

	// Adds a class of group-blog to blogs with more than 1 published author.
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Add a class for typography
	$typography = (  $options['theme_typography'] == 'default' ) ? '' :  $options['theme_typography'];
	$classes[] = esc_attr( $typography );

	$body_typography = (  $options['body_theme_typography'] == 'default' ) ? '' :  $options['body_theme_typography'];
	$classes[] = esc_attr( $body_typography );

	// Add a class for layout
	$classes[] = esc_attr( $options['site_layout'] );

	$blog_layout = ! empty( $options['archive_layout'] ) ? $options['archive_layout'] : 'list';
	$classes[] = esc_attr( $blog_layout );

	if ( ! $options['single_post_show_social'] ) {
		$classes[] = 'post-share-disabled';
	}

	if ( ! $options['testimonial_section_enable'] ) {
		$classes[] = 'testimonial-section-disabled';
	}

	$sticky = get_option( 'sticky_posts' );
	$classes[] = ( is_home() && empty( $sticky ) ) ? 'no-sticky-post' : 'has-sticky-post';

	if ( is_singular( 'page' ) ) {
		if ( ! has_post_thumbnail( get_the_id() ) && ! $options['single_post_show_social'] ) 
			$classes[] = 'no-page-thumbnail';
	}

	if ( is_singular() ) {
		$stored_sidebar_position = get_post_meta( get_the_id(), 'personify-pro-sidebar-position', true );
		$stored_sidebar_position = ! empty( $stored_sidebar_position ) ? $stored_sidebar_position : 'page-full-width';
		$classes[] = $stored_sidebar_position;
	}

	if ( class_exists( 'Jetpack' ) && Jetpack::is_module_active( 'subscriptions' ) ) {
		$classes[] = ( $options['subscription_section_enable'] ) ? 'newsletter-enabled' : '' ;
	}

	return $classes;
}
add_filter( 'body_class', 'personify_pro_body_classes' );
