<?php
/**
 * personify-pro custom helper funtions
 *
 * This is the template that includes all the other files for core featured of Photo Fusion Pro
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

if( ! function_exists( 'personify_pro_check_enable_status' ) ):
	/**
	 * Check status of content.
	 *
	 * @since Personify Pro 1.0
	 */
  	function personify_pro_check_enable_status( $input, $content_enable ){
		$options = personify_pro_get_theme_options();

		// Content status.
		$content_status = $options[ $content_enable ];

		if ( ( ! is_home() && is_front_page() ) && $content_status ) {
			$input = true;
		}
		else {
			$input = false;
		}
		
		return $input;
  	}
endif;
add_filter( 'personify_pro_section_status', 'personify_pro_check_enable_status', 10, 2 );


if ( ! function_exists( 'personify_pro_is_frontpage_content_enable' ) ) :
	/**
	 * Check home page ( static ) content status.
	 *
	 * @param bool $status Home page content status.
	 * @return bool Modified home page content status.
	 */
	function personify_pro_is_frontpage_content_enable( $status ) {
		if ( is_front_page() ) {
			$options = personify_pro_get_theme_options();
			$front_page_content_status = $options['enable_frontpage_content'];
			if ( false === $front_page_content_status ) {
				$status = false;
			}
		}
		return $status;
	}

endif;

add_filter( 'personify_pro_filter_frontpage_content_enable', 'personify_pro_is_frontpage_content_enable' );


add_action( 'personify_pro_action_pagination', 'personify_pro_pagination', 10 );
if ( ! function_exists( 'personify_pro_pagination' ) ) :

	/**
	 * pagination.
	 *
	 * @since Personify Pro 1.0
	 */
	function personify_pro_pagination() {
		$options = personify_pro_get_theme_options();
		if ( true == $options['pagination_enable'] ) {
			$pagination = $options['pagination_type'];
			if ( $pagination == 'default' ) :
				the_posts_navigation( array(
			'prev_text'	=> personify_pro_get_svg( array( 'icon' => 'left' ) ) . '<span>' . esc_html__( 'Previous', 'personify-pro' ) . '</span>',
            'next_text' => '<span>' . esc_html__( 'Next', 'personify-pro' ) . '</span>' . personify_pro_get_svg( array( 'icon' => 'right' ) ),
			) );
			elseif ( in_array( $pagination, array( 'numeric', 'infinite' ) ) ) :
				the_posts_pagination( array(
				    'mid_size' => 4,
				    'prev_text' => personify_pro_get_svg( array( 'icon' => 'left' ) ),
				    'next_text' => personify_pro_get_svg( array( 'icon' => 'right' ) ),
				) );
			endif;
		}
	}

endif;


add_action( 'personify_pro_action_post_pagination', 'personify_pro_post_pagination', 10 );
if ( ! function_exists( 'personify_pro_post_pagination' ) ) :

	/**
	 * post pagination.
	 *
	 * @since Personify Pro 1.0
	 */
	function personify_pro_post_pagination() {
		$options = personify_pro_get_theme_options();
		if ( false === $options['single_post_show_pagination'] ) {
			return;
		}
		
		the_post_navigation( array(
			'prev_text'	=> personify_pro_get_svg( array( 'icon' => 'left' ) ) .  '<span>%title</span>',
            'next_text' => '<span>%title</span>' . personify_pro_get_svg( array( 'icon' => 'right' ) ),
			) );
	}
endif;


if ( ! function_exists( 'personify_pro_excerpt_length' ) ) :
	/**
	 * long excerpt
	 * 
	 * @since Personify Pro 1.0
	 * @return long excerpt value
	 */
	function personify_pro_excerpt_length( $length ){
		if ( is_admin() ) {
			return $length;
		}

		$options = personify_pro_get_theme_options();
		$length = $options['long_excerpt_length'];
		return $length;
	}
endif;
add_filter( 'excerpt_length', 'personify_pro_excerpt_length', 999 );


if ( ! function_exists( 'personify_pro_excerpt_more' ) ) :
	// Read more
	function personify_pro_excerpt_more( $more ){
		return '...';
	}
endif;
add_filter( 'excerpt_more', 'personify_pro_excerpt_more' );


if ( ! function_exists( 'personify_pro_trim_content' ) ) :
	/**
	 * custom excerpt function
	 * 
	 * @since Personify Pro 1.0
	 * @return  no of words to display
	 */
	function personify_pro_trim_content( $length = 40, $post_obj = null ) {
		global $post;
		if ( is_null( $post_obj ) ) {
			$post_obj = $post;
		}

		$length = absint( $length );
		if ( $length < 1 ) {
			$length = 40;
		}

		$source_content = $post_obj->post_content;
		if ( ! empty( $post_obj->post_excerpt ) ) {
			$source_content = $post_obj->post_excerpt;
		}

		$source_content = preg_replace( '`\[[^\]]*\]`', '', $source_content );
		$trimmed_content = wp_trim_words( $source_content, $length, '...' );

	   return apply_filters( 'personify_pro_trim_content', $trimmed_content );
	}
endif;

/**
 * Add SVG definitions to the footer.
 */
function personify_pro_include_svg_icons() {
	// Define SVG sprite file.
	$svg_icons = get_template_directory() . '/assets/images/svg-icons.svg';

	// If it exists, include it.
	if ( file_exists( $svg_icons ) ) {
		require_once $svg_icons;
	}
}
add_action( 'wp_footer', 'personify_pro_include_svg_icons', 9999 );

/**
 * Return SVG markup.
 *
 * @param array $args {
 *     Parameters needed to display an SVG.
 *
 *     @type string $icon  Required SVG icon filename.
 *     @type string $title Optional SVG title.
 *     @type string $desc  Optional SVG description.
 * }
 * @return string SVG markup.
 */
function personify_pro_get_svg( $args = array() ) {
	// Make sure $args are an array.
	if ( empty( $args ) ) {
		return esc_html__( 'Please define default parameters in the form of an array.', 'personify-pro' );
	}

	// Define an icon.
	if ( false === array_key_exists( 'icon', $args ) ) {
		return esc_html__( 'Please define an SVG icon filename.', 'personify-pro' );
	}

	// Set defaults.
	$defaults = array(
		'icon'        => '',
		'title'       => '',
		'desc'        => '',
		'fallback'    => false,
	);

	// Parse args.
	$args = wp_parse_args( $args, $defaults );

	// Set aria hidden.
	$aria_hidden = ' aria-hidden="true"';

	// Set ARIA.
	$aria_labelledby = '';

	/*
	 * Theme Palace doesn't use the SVG title or description attributes; non-decorative icons are described with .screen-reader-text.
	 *
	 * However, child themes can use the title and description to add information to non-decorative SVG icons to improve accessibility.
	 *
	 * Example 1 with title: <?php echo personify_pro_get_svg( array( 'icon' => 'arrow-right', 'title' => __( 'This is the title', 'textdomain' ) ) ); ?>
	 *
	 * Example 2 with title and description: <?php echo personify_pro_get_svg( array( 'icon' => 'arrow-right', 'title' => __( 'This is the title', 'textdomain' ), 'desc' => __( 'This is the description', 'textdomain' ) ) ); ?>
	 *
	 * See https://www.paciellogroup.com/blog/2013/12/using-aria-enhance-svg-accessibility/.
	 */
	if ( $args['title'] ) {
		$aria_hidden     = '';
		$unique_id       = uniqid();
		$aria_labelledby = ' aria-labelledby="title-' . $unique_id . '"';

		if ( $args['desc'] ) {
			$aria_labelledby = ' aria-labelledby="title-' . $unique_id . ' desc-' . $unique_id . '"';
		}
	}

	// Begin SVG markup.
	$svg = '<svg class="icon icon-' . esc_attr( $args['icon'] ) . '"' . $aria_hidden . $aria_labelledby . ' role="img">';

	// Display the title.
	if ( $args['title'] ) {
		$svg .= '<title id="title-' . $unique_id . '">' . esc_html( $args['title'] ) . '</title>';

		// Display the desc only if the title is already set.
		if ( $args['desc'] ) {
			$svg .= '<desc id="desc-' . $unique_id . '">' . esc_html( $args['desc'] ) . '</desc>';
		}
	}

	/*
	 * Display the icon.
	 *
	 * The whitespace around `<use>` is intentional - it is a work around to a keyboard navigation bug in Safari 10.
	 *
	 * See https://core.trac.wordpress.org/ticket/38387.
	 */
	$svg .= ' <use href="#icon-' . esc_html( $args['icon'] ) . '" xlink:href="#icon-' . esc_html( $args['icon'] ) . '"></use> ';

	// Add some markup to use as a fallback for browsers that do not support SVGs.
	if ( $args['fallback'] ) {
		$svg .= '<span class="svg-fallback icon-' . esc_attr( $args['icon'] ) . '"></span>';
	}

	$svg .= '</svg>';

	return $svg;
}

/**
 * Add dropdown icon if menu item has children.
 *
 * @param  string $title The menu item's title.
 * @param  object $item  The current menu item.
 * @param  array  $args  An array of wp_nav_menu() arguments.
 * @param  int    $depth Depth of menu item. Used for padding.
 * @return string $title The menu item's title with dropdown icon.
 */
function personify_pro_dropdown_icon_to_menu_link( $title, $item, $args, $depth ) {
	if ( 'primary' === $args->theme_location ) {
		foreach ( $item->classes as $value ) {
			if ( 'menu-item-has-children' === $value || 'page_item_has_children' === $value ) {
				$title = $title . personify_pro_get_svg( array( 'icon' => 'down' ) );
			}
		}
	}

	return $title;
}
add_filter( 'nav_menu_item_title', 'personify_pro_dropdown_icon_to_menu_link', 10, 4 );

/**
 * Returns an array of supported social links (URL and icon name).
 *
 * @return array $social_links_icons
 */
function personify_pro_social_links_icons() {
	// Supported social links icons.
	$social_links_icons = array(
		'behance.net'     => 'behance',
		'imdb.com'     	  => 'imdb',
		'codepen.io'      => 'codepen',
		'deviantart.com'  => 'deviantart',
		'digg.com'        => 'digg',
		'dribbble.com'    => 'dribbble',
		'dropbox.com'     => 'dropbox',
		'facebook.com'    => 'facebook',
		'flickr.com'      => 'flickr',
		'foursquare.com'  => 'foursquare',
		'plus.google.com' => 'google-plus',
		'github.com'      => 'github',
		'instagram.com'   => 'instagram',
		'linkedin.com'    => 'linkedin',
		'mailto:'         => 'envelope-o',
		'medium.com'      => 'medium',
		'pinterest.com'   => 'pinterest-p',
		'getpocket.com'   => 'get-pocket',
		'reddit.com'      => 'reddit-alien',
		'skype.com'       => 'skype',
		'skype:'          => 'skype',
		'slideshare.net'  => 'slideshare',
		'snapchat.com'    => 'snapchat-ghost',
		'soundcloud.com'  => 'soundcloud',
		'spotify.com'     => 'spotify',
		'stumbleupon.com' => 'stumbleupon',
		'tumblr.com'      => 'tumblr',
		'twitch.tv'       => 'twitch',
		'twitter.com'     => 'twitter',
		'vimeo.com'       => 'vimeo',
		'vine.co'         => 'vine',
		'vk.com'          => 'vk',
		'wordpress.org'   => 'wordpress',
		'wordpress.com'   => 'wordpress',
		'yelp.com'        => 'yelp',
		'youtube.com'     => 'youtube',
		'reverbnation.com' => 'reverbnation',
	);

	/**
	 * Filter Theme Palace social links icons.
	 *
	 * @since Personify Pro 1.0
	 *
	 * @param array $social_links_icons Array of social links icons.
	 */
	return apply_filters( 'personify_pro_social_links_icons', $social_links_icons );
}

/**
 * Display SVG icons in social links menu.
 *
 * @param  string  $item_output The menu item output.
 * @param  WP_Post $item        Menu item object.
 * @param  int     $depth       Depth of the menu.
 * @param  array   $args        wp_nav_menu() arguments.
 * @return string  $item_output The menu item output with social icon.
 */
function personify_pro_nav_menu_social_icons( $item_output, $item, $depth, $args ) {
	// Get supported social icons.
	$social_icons = personify_pro_social_links_icons();

	// Change SVG icon inside social links menu if there is supported URL.
	if ( 'social' === $args->theme_location ) {
		foreach ( $social_icons as $attr => $value ) {
			if ( false !== strpos( $item_output, $attr ) ) {
				$item_output = str_replace( $args->link_after, '</span>' . personify_pro_get_svg( array( 'icon' => esc_attr( $value ) ) ), $item_output );
			}
		}
	}

	return $item_output;
}
add_filter( 'walker_nav_menu_start_el', 'personify_pro_nav_menu_social_icons', 10, 4 );

/**
 * Fallback function call for menu
 * @param  Mixed $args Menu arguments
 * @return String $output Return or echo the add menu link.       
 */
function personify_pro_menu_fallback_cb( $args ){
    if ( ! current_user_can( 'edit_theme_options' ) ){
	    return;
   	}
    // see wp-includes/nav-menu-template.php for available arguments
    $link = $args['link_before']
        	. '<a href="' .esc_url( admin_url( 'nav-menus.php' ) ) . '">' . $args['before'] . esc_html__( 'Add a menu','personify-pro' ) . $args['after'] . '</a>'
        	. $args['link_after'];

   	if ( FALSE !== stripos( $args['items_wrap'], '<ul' ) || FALSE !== stripos( $args['items_wrap'], '<ol' )
	){
		$link = "<li>$link</li>";
	}
	$output = sprintf( $args['items_wrap'], $args['menu_id'], $args['menu_class'], $link );
	if ( ! empty ( $args['container'] ) ){
		$output = sprintf( '<%1$s class="%2$s" id="%3$s">%4$s</%1$s>', $args['container'], $args['container_class'], $args['container_id'], $output );
	}
	if ( $args['echo'] ){
		echo $output;
	}
	return $output;
}

/**
 * Display SVG icons as per the link.
 *
 * @param  string   $social_link        Theme mod value rendered
 * @return string  SVG icon HTML
 */
function personify_pro_return_social_icon( $social_link ) {
	// Get supported social icons.
	$social_icons = personify_pro_social_links_icons();

	// Check in the URL for the url in the array.
	foreach ( $social_icons as $attr => $value ) {
		if ( false !== strpos( $social_link, $attr ) ) {
			return personify_pro_get_svg( array( 'icon' => esc_attr( $value ) ) );
		}
	}
}

add_action( 'personify_pro_simple_breadcrumb', 'personify_pro_simple_breadcrumb' , 10 );
if ( ! function_exists( 'personify_pro_simple_breadcrumb' ) ) :

	/**
	 * Simple breadcrumb.
	 *
	 * @param  array $args Arguments
	 */
	function personify_pro_simple_breadcrumb( $args = array() ) {
		// call breadcrumb
		$args = array(
			'show_on_front'   => false,
			'show_title'      => true,
			'show_browse'     => false,
		);
		breadcrumb_trail( $args );      

		return;
	}

endif;

if ( ! function_exists( 'personify_pro_blog_pre_post' ) ) :
	/**
	 * Pre get posts for blog page
	 *
	 * @since Personify Pro 1.0
	 */
	function personify_pro_blog_pre_post( $query ) {
		
		$options = personify_pro_get_theme_options(); // get theme options
		$exclude_category = ! empty( $options['blog_exclude_categories'] ) ? ( array ) $options['blog_exclude_categories'] : array();

		if ( is_home() ){
			if ( ! is_admin() && $query->is_main_query() )
				$query->set( 'category__not_in', $exclude_category );
		}

		if ( is_home() || is_archive() || is_search() ) {
			if ( 'infinite' == $options['pagination_type'] && ! is_admin() && $query->is_main_query() )
				$query->set( 'posts_per_page', 6 );
		}
		
	}
endif;
add_action( 'pre_get_posts', 'personify_pro_blog_pre_post' );

if ( ! function_exists( 'personify_pro_get_content' ) ) :
	/*
	 * archive content 
	 */
	function personify_pro_get_content( $i, $int ) {
		$options = personify_pro_get_theme_options();
		$class = ( has_post_thumbnail() ) ? '' : 'no-post-thumbnail';
		$class .= ( 1 === $int ) ? ' add-gap' : '';
		$class .= ( ( $i % 3 == 0 ) && $i !== 0 && is_home() ) ? ' clear-left' : '';
		$class .= ( ( $i % 2 == 0 ) && $i !== 0 && is_home() ) ? ' clear-left-responsive' : '';
		$img_size = ( is_sticky() && is_home() ) ? 'full' : 'large';
		?>

		<article id="post-<?php the_ID(); ?>" <?php post_class( esc_attr( $class ) ); ?>>

			<?php if ( has_post_thumbnail() ) : ?>
				<div class="featured-image">
			        <a href="<?php the_permalink(); ?>">
			        	<div class="blog-featured-image" style="background-image: url('<?php echo esc_url( get_the_post_thumbnail_url( '', $img_size ) ); ?>');"></div>
			            <div class="red-overlay"></div>
			            <?php echo personify_pro_get_svg( array( 'icon' => 'add' ) ); ?>
			        </a>
			        <?php if ( 'post' === get_post_type() && 'blog-list' == $options['archive_layout'] ) :
			        	personify_pro_categories();
			        endif; ?>
			    </div><!-- .featured-image -->
			<?php endif; ?>

			<div class="entry-summary">
				<div class="entry-container">
			        <header class="entry-header">
			          	<?php if ( 'post' === get_post_type() && 'list' == $options['archive_layout'] ) : ?>
							<div class="entry-meta">
								<?php personify_pro_posted_on(); ?>
							</div><!-- .entry-meta -->
						<?php elseif ( 'post' === get_post_type() && 'blog-list' == $options['archive_layout'] && ! has_post_thumbnail() ) : ?>
							<div class="entry-meta">
								<?php personify_pro_categories(); ?>
							</div><!-- .entry-meta -->
						<?php endif; ?>
			            <h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
			            <?php if ( 'post' === get_post_type() && 'blog-list' == $options['archive_layout'] ) : ?>
			            	<div class="entry-meta">
			            		<?php personify_pro_posted_date(); ?>
			            	</div>
			            <?php endif; ?>
			        </header>

			        <div class="entry-content">
			            <?php
						the_excerpt();

						wp_link_pages( array(
							'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'personify-pro' ),
							'after'  => '</div>',
						) );
					?>
			        </div><!-- .entry-content --> 
			    
			    	<?php if ( true === $options['show_author'] && true === $options['show_comments'] ) : ?>
				        <div class="entry-meta author-comments">
				        	<?php if ( true === $options['show_author'] ) :
						        personify_pro_author();
						    endif; 

						    personify_pro_entry_footer(); ?>
				        </div><!-- .entry-meta -->
			        <?php endif; ?>

			        <?php personify_pro_edit_link(); ?>
			        
			        <div class="separator"></div>
		        </div><!-- .entry-container -->
		    </div><!-- .entry-summary -->

		</article><!-- #post-## -->
	<?php }
endif;
add_action( 'personify_pro_get_content_action', 'personify_pro_get_content', 10, 2 );
