<?php
/**
 * personify-pro options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

if ( ! function_exists( 'personify_pro_enable_options' ) ) :
    /**
    * Returns list of enable option
    * @return array font styles
    */
    function personify_pro_enable_options(){

        $choices = array(
            'on'         => esc_html__( 'Enable', 'personify-pro' ),
            'off'        => esc_html__( 'Disable', 'personify-pro' ),
        );
        $output = apply_filters( 'personify_pro_typography_options', $choices );

        return $output;
    }
endif;

if ( ! function_exists( 'personify_pro_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function personify_pro_typography_options(){
        $choices = array(
          'default'         => esc_html__( 'Default', 'personify-pro' ),
          'header-font-1'   => esc_html__( 'Rajdhani', 'personify-pro' ),
          'header-font-2'   => esc_html__( 'Cherry Swash', 'personify-pro' ),
          'header-font-3'   => esc_html__( 'Philosopher', 'personify-pro' ),
          'header-font-4'   => esc_html__( 'Slabo 27px', 'personify-pro' ),
          'header-font-5'   => esc_html__( 'Dosis', 'personify-pro' ),
        );

        $output = apply_filters( 'personify_pro_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;


if ( ! function_exists( 'personify_pro_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function personify_pro_body_typography_options(){
        $choices = array(
          'default'         => esc_html__( 'Default', 'personify-pro' ),
          'body-font-1'     => esc_html__( 'News Cycle', 'personify-pro' ),
          'body-font-2'     => esc_html__( 'Pontano Sans', 'personify-pro' ),
          'body-font-3'     => esc_html__( 'Gudea', 'personify-pro' ),
          'body-font-4'     => esc_html__( 'Quattrocento', 'personify-pro' ),
          'body-font-5'     => esc_html__( 'Khand', 'personify-pro' ),
        );

        $output = apply_filters( 'personify_pro_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'personify_pro_site_layout' ) ) :
    /**
     * Site Layout
     * @return array site layout options
     */
    function personify_pro_site_layout() {
        $personify_pro_site_layout = array(
            'wide'  => get_template_directory_uri() . '/assets/images/full.png',
            'boxed' => get_template_directory_uri() . '/assets/images/boxed.png',
        );

        $output = apply_filters( 'personify_pro_site_layout', $personify_pro_site_layout );
        return $output;
    }
endif;


if ( ! function_exists( 'personify_pro_pagination_options' ) ) :
    /**
     * Pagination
     * @return array site pagination options
     */
    function personify_pro_pagination_options() {
        $personify_pro_pagination_options = array(
            'numeric'   => esc_html__( 'Numeric', 'personify-pro' ),
            'default'   => esc_html__( 'Default(Older/Newer)', 'personify-pro' ),
            'infinite'  => esc_html__( 'Infinite', 'personify-pro' ),
        );

        $output = apply_filters( 'personify_pro_pagination_options', $personify_pro_pagination_options );

        return $output;
    }
endif;

if ( ! function_exists( 'personify_pro_get_spinner_list' ) ) :
    /**
     * List of spinner icons options.
     * @return array List of all spinner icon options.
     */
    function personify_pro_get_spinner_list() {
        $arr = array(
            'default'               => esc_html__( 'Default', 'personify-pro' ),
            'spinner-wheel'         => esc_html__( 'Wheel', 'personify-pro' ),
            'spinner-double-circle' => esc_html__( 'Double Circle', 'personify-pro' ),
            'spinner-two-way'       => esc_html__( 'Two Way', 'personify-pro' ),
            'spinner-umbrella'      => esc_html__( 'Umbrella', 'personify-pro' ),
            'spinner-circle'        => esc_html__( 'Circle', 'personify-pro' ),
            'spinner-dots'          => esc_html__( 'Dots', 'personify-pro' ),
            'spinner-one-way'       => esc_html__( 'One Way', 'personify-pro' ),
            'spinner-fidget'        => esc_html__( 'Fidget', 'personify-pro' ),
        );
        return apply_filters( 'personify_pro_spinner_list', $arr );
    }
endif;

if ( ! function_exists( 'personify_pro_sidebar_position' ) ) :
    /**
     * Sidebar position
     * @return array Sidbar positions
     */
    function personify_pro_sidebar_position() {
        $personify_pro_sidebar_position = array(
            'page-full-width'     => get_template_directory_uri() . '/assets/images/full.png',
            'page-content-width'  => get_template_directory_uri() . '/assets/images/boxed.png',
        );

        $output = apply_filters( 'personify_pro_sidebar_position', $personify_pro_sidebar_position );

        return $output;
    }
endif;
