<?php
/**
 * About section
 *
 * This is the template for the content of about section
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */
if ( ! function_exists( 'personify_pro_add_about_section' ) ) :
    /**
    * Add about section
    *
    *@since Personify Pro 1.0
    */
    function personify_pro_add_about_section() {
        // Check if about is enabled on frontpage
        $about_enable = apply_filters( 'personify_pro_section_status', true, 'about_section_enable' );

        if ( true !== $about_enable ) {
            return false;
        }
        // Get about section details
        $section_details = array();
        $section_details = apply_filters( 'personify_pro_filter_about_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render about section now.
        personify_pro_render_about_section( $section_details );
    }
endif;
add_action( 'personify_pro_primary_content', 'personify_pro_add_about_section', 20 );


if ( ! function_exists( 'personify_pro_get_about_section_details' ) ) :
    /**
    * about section details.
    *
    * @since Personify Pro 1.0
    * @param array $input about section details.
    */
    function personify_pro_get_about_section_details( $input ) {
        $options = personify_pro_get_theme_options();

        // Content type.
        $about_content_type  = $options['about_content_type'];
        $content = array();
        switch ( $about_content_type ) {
            case 'demo':
                $demo['title']      = sprintf( '<span> %1$s </span> %2$s <span> %3$s </span> %4$s', esc_html__( 'Jake Gyllenhaal', 'personify-pro' ), esc_html__( 'is an american', 'personify-pro' ), esc_html__( 'Actor', 'personify-pro' ), esc_html__( ' a leo quis massa interdum porttitor eu at.', 'personify-pro' ) );
                $demo['sub_title']  = esc_html__( 'He is an American actor who played in various famous movies like Source Code, Love and other Drugs, Everest...', 'personify-pro' );
                $demo['excerpt']    = sprintf( '<p> %1$s </p> <p> %2$s </p>', esc_html__( 'Gyllenhaal pulvinar lacus purus, eget laoreet massa accumsan quis. Que mattis bibendum felis, sit amet blandit quam fini buset ed  vitae elit vitae ligula pretium efficitur nec non massa. Sed posuere pellentesque justo, vitae elementum tellus suscipit in. Integer semper velit sit amet libero luctus, vitae interdum dui tempor. In lacinia neque at tristique vulputate. Donec semper est faucibus varius egestas. Sed tristique, augue quis tempor gravida, ligula tellus convallis ipsum, vestibulum ultrices dui erat vitae erat. Donec eget ante et nunc auctor congue. Interdum et malesuada fames ac ante ipsum primis in faucibus.', 'personify-pro' ), esc_html__( 'Quisque dignissim, leo sed venenatis dapibus, mi nunc euismod neque, eget malesuada est nisi nec justo. Duis ultricies nulla sed mauris eleifend accumsan.', 'personify-pro' ) );

                // Push to the main array.
                array_push( $content, $demo );
            break;

            case 'custom':
                $custom['title']        = ! empty( $options['about_title'] ) ? $options['about_title'] : '';
                $custom['sub_title']    = ! empty( $options['about_sub_title'] ) ? $options['about_sub_title'] : '';
                $custom['excerpt']      = ! empty( $options['about_description'] ) ? wpautop( $options['about_description'] ) : '';

                // Push to the main array.
                array_push( $content, $custom );
            break;

            case 'page':
                $page_id = ! empty( $options['about_content_page'] ) ? $options['about_content_page'] : '';
                $args = array(
                    'post_type'         => 'page',
                    'page_id'           => $page_id,
                    'posts_per_page'    => 1,
                    );                    
            break;

            case 'post':
                $post_id = ! empty( $options['about_content_post'] ) ? $options['about_content_post'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'p'                 => $post_id,
                    'posts_per_page'    => 1,
                    );
            break;

            default:
            break;
        }

        if ( 'post' === $about_content_type || 'page' === $about_content_type ) {

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['title']     = get_the_title();
                    $page_post['sub_title'] = has_excerpt() ? get_the_excerpt() : '';
                    $page_post['excerpt']   = wpautop( get_the_content() );

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();

        }

    if ( ! empty( $content ) ) {
        $input = $content;
    }
    return $input;
    }
endif;
// about section content details.
add_filter( 'personify_pro_filter_about_section_details', 'personify_pro_get_about_section_details' );


if ( ! function_exists( 'personify_pro_render_about_section' ) ) :
  /**
   * Start about section
   *
   * @return string about content
   * @since Personify Pro 1.0
   *
   */
   function personify_pro_render_about_section( $content_details = array() ) {
        $options = personify_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } 

        foreach ( $content_details as $content ) : ?>
            <div id="about-section" class="relative page-section <?php echo ( empty( $content['sub_title'] ) ) ? 'subtitle-disabled' : ''; ?>">
                <div class="wrapper">
                    <article id="post-02" class="hentry">
                        <?php if ( ! empty( $content['title'] ) ) : ?>
                            <header class="entry-header">
                                <h2 class="entry-title">
                                    <?php echo personify_pro_santize_span( $content['title'] ); ?>
                                </h2>
                            </header>
                        <?php endif; ?>

                        <?php if ( ! empty( $content['excerpt'] ) ) : ?>
                            <div class="entry-content">
                                <?php echo wp_kses_post( $content['excerpt'] ); ?>
                            </div><!-- .entry-content -->
                        <?php endif; 

                        if ( ! empty( $content['sub_title'] ) ) : ?>
                            <div class="description">
                                <?php echo wp_kses_post( $content['sub_title'] ); ?>
                            </div><!-- .description -->
                        <?php endif; 

                        if ( true == $options['about_social_section_enable'] && has_nav_menu( 'social' ) ) : ?>
                            <div class="get-in-touch">
                                <small><?php esc_html_e( 'Get In Touch', 'personify-pro' ); ?></small>
                                <?php wp_nav_menu( array( 
                                    'theme_location' => 'social', 
                                    'menu_id'        => 'social-menu',
                                    'menu_class'     => 'social-icons',
                                    'fallback_cb'    => false,
                                    'depth'          => 1,
                                    'link_before'    => '<span class="screen-reader-text">',
                                    'link_after'     => '</span>' . personify_pro_get_svg( array( 'icon' => 'chain' ) ),
                                ) ); ?>
                            </div><!-- .get-in-touch -->
                        <?php endif; ?>
                    </article>
                </div><!-- .wrapper -->
            </div><!-- #about-section -->
        <?php endforeach;
    }
endif;