<?php
/**
 * Event section
 *
 * This is the template for the content of event section
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */
if ( ! function_exists( 'personify_pro_add_event_section' ) ) :
    /**
    * Add event section
    *
    *@since Personify Pro 1.0
    */
    function personify_pro_add_event_section() {
        // Check if event is enabled on frontpage
        $event_enable = apply_filters( 'personify_pro_section_status', true, 'event_section_enable' );

        if ( true !== $event_enable ) {
            return false;
        }
        // Get event section details
        $section_details = array();
        $section_details = apply_filters( 'personify_pro_filter_event_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render event section now.
        personify_pro_render_event_section( $section_details );
    }
endif;
add_action( 'personify_pro_primary_content', 'personify_pro_add_event_section', 80 );


if ( ! function_exists( 'personify_pro_get_event_section_details' ) ) :
    /**
    * event section details.
    *
    * @since Personify Pro 1.0
    * @param array $input event section details.
    */
    function personify_pro_get_event_section_details( $input ) {
        $options = personify_pro_get_theme_options();

        // Content type.
        $event_content_type  = $options['event_content_type'];
        $event_count  = ! empty( $options['event_section_count'] ) ? $options['event_section_count'] : 5;

        $content = array();
        switch ( $event_content_type ) {
            case 'demo':
                $title = array(
                    1 => esc_html__( 'My 1st Step', 'personify-pro' ),
                    2 => esc_html__( 'Acting for life', 'personify-pro' ),
                    3 => esc_html__( 'Journey to Hollywood', 'personify-pro' ),
                    4 => esc_html__( 'Before Acting Career', 'personify-pro' ),
                    5 => esc_html__( 'American Dream', 'personify-pro' ),
                    );
                $date = array(
                    1 => esc_html( 'September 09 2017', 'personify-pro' ),
                    2 => esc_html( 'August 23 2017', 'personify-pro' ),
                    3 => esc_html( 'July 23 2017', 'personify-pro' ),
                    4 => esc_html( 'June 15 2017', 'personify-pro' ),
                    5 => esc_html( 'May 02 2017', 'personify-pro' ),
                    );
                for ( $i = 1; $i <= 5; $i++ ) {
                    $demo['title']      = $title[$i];
                    $demo['url']        = '#';
                    $demo['date']       = $date[$i];
                    $demo['date_url']   = '#';
                    $demo['excerpt']    = esc_html__( 'Praesent egestas tortor a ante gravida ultrices. Praesent tincidunt eleifend massa ut eleifend. Ut eget erat imperdiet, egestas purus volutpat, elementum nunc.', 'personify-pro' );

                    // Push to the main array.
                    array_push( $content, $demo );
                }
            break;

            case 'category':
                $cat_id = ! empty( $options['event_content_category'] ) ? $options['event_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'cat'               => absint( $cat_id ),
                    'posts_per_page'    => absint( $event_count ),
                    );                    
            break;

            case 'post':
                $post_id = ! empty( $options['event_content_post'] ) ? $options['event_content_post'] : '';
                $args = array(
                    'post_type'             => 'post',
                    'orderby'               => 'post__in',
                    'post__in'              => $post_id,
                    'posts_per_page'        => count( $post_id ),
                    'ignore_sticky_posts'   => true,
                    );
            break;

            default:
            break;
        }

        if (  in_array( $event_content_type, array( 'post', 'category' ) ) ) {

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $year  = get_the_time( 'Y', get_the_id() );
                    $month = get_the_time( 'm', get_the_id() );
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['date']      = get_the_date();
                    $page_post['date_url']  = get_month_link( $year, $month );
                    $page_post['excerpt']   = personify_pro_trim_content( 23 );

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();

        }

    if ( ! empty( $content ) ) {
        $input = $content;
    }
    return $input;
    }
endif;
// event section content details.
add_filter( 'personify_pro_filter_event_section_details', 'personify_pro_get_event_section_details' );


if ( ! function_exists( 'personify_pro_render_event_section' ) ) :
  /**
   * Start event section
   *
   * @return string event content
   * @since Personify Pro 1.0
   *
   */
   function personify_pro_render_event_section( $content_details = array() ) {
        $options = personify_pro_get_theme_options();
        $background = ! empty( $options['event_background_image'] ) ? $options['event_background_image'] : get_template_directory_uri() . '/assets/uploads/upcoming-event.jpg';
        $social_count = ! empty( $options['event_social_count'] ) ? $options['event_social_count'] : 1;
        $class = ( 'left' == $options['event_content_align'] ) ? 'content-left' : '';
        if ( empty( $content_details ) ) {
            return;
        } ?>
        <div id="upcoming-events" class="relative page-section <?php echo esc_attr( $class ); ?>" style="background-image:url('<?php echo esc_url( $background ); ?>');">
            <div class="black-overlay"></div>
            <div class="wrapper">
                <div class="section-content col-2">
                    <div class="column-wrapper">
                        <div class="follow-upcoming-events">
                            <?php for ( $i = 1; $i <= absint( $social_count ); $i++ ) :
                                $social_link = isset( $options['event_social_link_' . $i] ) ? $options['event_social_link_' . $i] : $options['event_social_link'];
                                $social_label = isset( $options['event_social_label_' . $i] ) ? $options['event_social_label_' . $i] : $options['event_social_label'];
                                if ( ! empty( $social_link ) ) : ?>
                                    <a href="<?php echo esc_url( $social_link ); ?>" target="_blank">
                                        <?php echo personify_pro_return_social_icon( $social_link ); 

                                        if ( ! empty( $social_label ) ) : ?>
                                            <span><?php echo esc_html( $social_label ); ?></span>
                                        <?php endif; ?>
                                    </a>
                                <?php endif; 
                            endfor; ?>
                        </div><!-- .follow-upcoming-events -->
                    </div><!-- .column-wrapper -->

                    <div class="column-wrapper events-column">
                        <?php if ( ! empty( $options['event_section_title'] ) ) : 
                            $title = explode( ' ', $options['event_section_title'] );
                            $first_word = $title[0];
                            $title = implode( ' ', array_slice( $title, 1 ) );
                            ?>
                            <div class="section-header">
                                <h2 class="section-title"><span><?php echo esc_html( $first_word ); ?></span> <?php echo esc_html( $title ); ?></h2>
                            </div><!-- .section-header -->
                        <?php endif; 

                        if ( ! empty( $options['event_section_description'] ) ) : ?>
                            <div class="event-short-description">
                                <p><?php echo wp_kses_post( $options['event_section_description'] ); ?></p>
                            </div><!-- .event-short-description -->
                        <?php endif; ?>

                        <div class="events-wrapper">
                            <?php foreach ( $content_details as $content ) : ?>
                                <article id="event-01" class="hentry">
                                    <div class="entry-meta">
                                        <span class="posted-on">
                                            <time class="entry-date published updated"><?php echo date_i18n( get_option( 'date_format' ), strtotime( $content['date'] ) ); ?></time>
                                        </span><!-- .posted-on -->
                                    </div><!-- .entry-meta -->

                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>

                                    <div class="entry-content"><?php echo esc_html( $content['excerpt'] ); ?></div><!-- .entry-content -->
                                    <div class="separator"></div>
                                </article>
                            <?php endforeach; ?>
                        </div><!-- .events-wrapper -->
                    </div><!-- .column-wrapper -->
                </div><!-- .section-content -->
            </div><!-- .wrapper -->
        </div><!-- #upcoming-events -->
    <?php }
endif;