<?php
/**
 * Featured section
 *
 * This is the template for the content of featured section
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */
if ( ! function_exists( 'personify_pro_add_featured_section' ) ) :
    /**
    * Add featured section
    *
    *@since Personify Pro 1.0
    */
    function personify_pro_add_featured_section() {
        // Check if featured is enabled on frontpage
        $featured_enable = apply_filters( 'personify_pro_section_status', true, 'featured_section_enable' );

        if ( true !== $featured_enable ) {
            return false;
        }
        // Get featured section details
        $section_details = array();
        $section_details = apply_filters( 'personify_pro_filter_featured_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render featured section now.
        personify_pro_render_featured_section( $section_details );
    }
endif;
add_action( 'personify_pro_primary_content', 'personify_pro_add_featured_section', 30 );


if ( ! function_exists( 'personify_pro_get_featured_section_details' ) ) :
    /**
    * featured section details.
    *
    * @since Personify Pro 1.0
    * @param array $input featured section details.
    */
    function personify_pro_get_featured_section_details( $input ) {
        $options = personify_pro_get_theme_options();

        // Content type.
        $featured_content_type  = $options['featured_content_type'];
        $content = array();
        switch ( $featured_content_type ) {
            case 'demo':
                $title = array(
                    1 => esc_html__( 'Early Life', 'personify-pro' ),
                    2 => esc_html__( 'Acting Careers (1991-Present)', 'personify-pro' ),
                    3 => esc_html__( 'Filmography', 'personify-pro' ),
                    );
                $date = array(
                    1 => esc_html( '01 January 1971', 'personify-pro' ),
                    2 => esc_html( '21 August 2008', 'personify-pro' ),
                    3 => esc_html( '16 November 2009', 'personify-pro' ),
                    );
                for ( $i = 1; $i <= 3; $i++ ) {
                    $demo['id']         = '';
                    $demo['title']      = $title[$i];
                    $demo['url']        = '#';
                    $demo['excerpt']    = esc_html__( 'Praesent egestas tortor a ante gravida ultrices. Praesent tincidunt eleifend massa ut eleifend. Ut eget erat imperdiet, egestas purus volutpat, elementum nunc.', 'personify-pro' );
                    $demo['date']       = $date[$i];
                    $demo['date_url']   = '#';

                    // Push to the main array.
                    array_push( $content, $demo );
                }
            break;

            case 'category':
                $cat_id = ! empty( $options['featured_content_category'] ) ? $options['featured_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'cat'               => absint( $cat_id ),
                    'posts_per_page'    => 3,
                    );                    
            break;

            case 'post':
                $post_id = ! empty( $options['featured_content_post'] ) ? $options['featured_content_post'] : '';
                $args = array(
                    'post_type'             => 'post',
                    'orderby'               => 'post__in',
                    'post__in'              => $post_id,
                    'posts_per_page'        => 3,
                    'ignore_sticky_posts'   => true,
                    );
            break;

            default:
            break;
        }

        if ( 'post' === $featured_content_type || 'category' === $featured_content_type ) {

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $year  = get_the_time( 'Y', get_the_id() );
                    $month = get_the_time( 'm', get_the_id() );
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['date']      = get_the_date();
                    $page_post['date_url']  = get_month_link( $year, $month );
                    $page_post['excerpt']   = personify_pro_trim_content( 25 );
                    $page_post['url']       = get_the_permalink();

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();

        }

    if ( ! empty( $content ) ) {
        $input = $content;
    }
    return $input;
    }
endif;
// featured section content details.
add_filter( 'personify_pro_filter_featured_section_details', 'personify_pro_get_featured_section_details' );


if ( ! function_exists( 'personify_pro_render_featured_section' ) ) :
  /**
   * Start featured section
   *
   * @return string featured content
   * @since Personify Pro 1.0
   *
   */
   function personify_pro_render_featured_section( $content_details = array() ) {
        $options = personify_pro_get_theme_options();
        $featured_content_type  = $options['featured_content_type'];
        $read_more = ! empty( $options['read_more_text'] ) ? $options['read_more_text'] : esc_html__( 'Read', 'personify-pro' );
        $featured_image     = ! empty( $options['featured_image'] ) ? $options['featured_image'] : '';
        $featured_caption   = ! empty( $options['featured_image_caption'] ) ? $options['featured_image_caption'] : '';
        $class = ( 'left' == $options['featured_image_align'] ) ? ' featured-image-left' : '';
        $class .= ( true !== $options['featured_image_enable'] || empty( $featured_image ) ) ? ' no-featured-image' : '';

        if ( empty( $content_details ) ) {
            return;
        } ?>
        <div id="latest-posts" class="relative<?php echo esc_attr( $class ); ?>">
            <div class="wrapper">
                <div class="section-content clear">
                    <div class="posts-wrapper">
                        <?php foreach( $content_details as $content ) : ?>
                            <article class="hentry">
                                <div class="entry-meta">
                                    <span class="posted-on">
                                        <a href="<?php echo esc_url( $content['date_url'] ); ?>"><time class="entry-date published updated"><?php echo date_i18n( get_option( 'date_format' ), strtotime( $content['date'] ) ); ?></time></a>
                                    </span><!-- .posted-on -->
                                    <span class="post-categories">
                                        <?php if ( 'demo' == $featured_content_type ) : ?>
                                            <a href="#"><?php esc_html_e( 'Personify Life', 'personify-pro' ); ?></a>
                                        <?php else :
                                            the_category( ', ', '', $content['id'] ); 
                                        endif; ?>
                                    </span><!-- .post-categroies -->
                                </div><!-- .entry-meta -->

                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                </header>

                                <div class="entry-content"><?php echo esc_html( $content['excerpt'] ); ?></div><!-- .entry-content -->

                                <span class="read-more">
                                    <a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $read_more ); ?></a>
                                </span><!-- .read-more -->
                            </article>
                        <?php endforeach; ?>
                    </div><!-- .posts-wrapper -->
                    <?php if ( true === $options['featured_image_enable'] && ! empty( $featured_image ) ) : ?>
                        <div class="featured-image-wrapper">
                            <div class="featured-image" style="background-image: url('<?php echo esc_url( $featured_image ); ?>');">
                                <p class="designation"><?php echo personify_pro_santize_span( $featured_caption ); ?></p>
                            </div><!-- .featured-image -->
                        </div><!-- .featured-image-wrapper -->
                    <?php endif; ?>
                </div><!-- .section-content -->
            </div><!-- .wrapper -->
        </div><!-- #latest-posts -->
    <?php }
endif;