<?php
/**
 * Social Feeds Section
 *
 * This is the template for the content of Social Feeds Section
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */
if ( ! function_exists( 'personify_pro_add_feeds_section' ) ) :
    /**
    * Add Social Feeds Section
    *
    *@since Personify Pro 1.0
    */
    function personify_pro_add_feeds_section() {
        // Check if feeds is enabled on frontpage
        $feeds_enable = apply_filters( 'personify_pro_section_status', true, 'feeds_section_enable' );

        if ( true !== $feeds_enable ) {
            return false;
        }

        // Render Social Feeds Section now.
        personify_pro_render_feeds_section();
    }
endif;
add_action( 'personify_pro_footer_content', 'personify_pro_add_feeds_section', 10 );


if ( ! function_exists( 'personify_pro_render_feeds_section' ) ) :
    /**
    * Start Social Feeds Section
    *
    * @return string feeds content
    * @since Personify Pro 1.0
    *
    */
    function personify_pro_render_feeds_section() {
        $options    = personify_pro_get_theme_options();
        $instagram  = ! empty( $options['instagram_username'] ) ? $options['instagram_username'] : ''; 
        $column     = ! empty( $options['instagram_column'] ) ? $options['instagram_column'] : 'col-5'; 
        $count      = ! empty( $options['instagram_count'] ) ? $options['instagram_count'] : '5'; 

        if ( empty( $instagram ) ) {
            return;
        }
        ?>
        <div id="social-medias" class="relative page-section">
            <div class="wrapper">
                <?php if ( ! empty( $options['feeds_title'] ) ) :
                    $title = explode( ' ', $options['feeds_title'] );
                    $first_word = $title[0];
                    $title = implode( ' ', array_slice( $title, 1 ) );
                    ?>
                    <div class="section-header align-center">
                        <h2 class="section-title"><span><?php echo esc_html( $first_word ); ?></span> <?php echo esc_html( $title ); ?></h2>
                    </div><!-- .section-header -->
                <?php endif; ?>
                <div class="section-content">
                    <?php 
                    $instagram_instance = array(
                        'title'    => '',
                        'username' => esc_attr( $instagram ),
                        'layout'   => esc_attr( $column ),
                        'number'   => absint( $count ),
                        'size'     => 'small',
                        'target'   => 1,
                        'link_text'     => '',
                    );

                    the_widget( 'Personify_Pro_Instagram_Widget', $instagram_instance ); 
                    ?>
                </div><!-- .section-content -->
            </div><!-- .wrapper -->
        </div><!-- .#social-medias -->
	<?php }
endif;
