<?php
/**
 * Introduction Section
 *
 * This is the template for the content of Introduction Section
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */
if ( ! function_exists( 'personify_pro_add_introduction_section' ) ) :
    /**
    * Add Introduction Section
    *
    *@since Personify Pro 1.0
    */
    function personify_pro_add_introduction_section() {
        // Check if about is enabled on frontpage
        $introduction_enable = apply_filters( 'personify_pro_section_status', true, 'introduction_section_enable' );

        if ( true !== $introduction_enable ) {
            return false;
        }
        // Get Introduction Section details
        $section_details = array();
        $section_details = apply_filters( 'personify_pro_filter_introduction_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render Introduction Section now.
        personify_pro_render_introduction_section( $section_details );
    }
endif;
add_action( 'personify_pro_primary_content', 'personify_pro_add_introduction_section', 10 );


if ( ! function_exists( 'personify_pro_get_introduction_section_details' ) ) :
    /**
    * Introduction Section details.
    *
    * @since Personify Pro 1.0
    * @param array $input Introduction Section details.
    */
    function personify_pro_get_introduction_section_details( $input ) {
        $options = personify_pro_get_theme_options();

        // Content type.
        $introduction_content_type  = $options['introduction_content_type'];
        $content = array();
        switch ( $introduction_content_type ) {
            case 'demo':
                $demo['firstname']  = esc_html__( 'Jake', 'personify-pro' );
                $demo['lastname']   = esc_html__( 'Gyllenhaal', 'personify-pro' );
                $demo['profession'] = esc_html__( 'Famous American Actor', 'personify-pro' );
                $demo['excerpt']    = esc_html__( 'I\'m a American actor who played in various famous movies like Source Code, Love & other Drugs, Everest...', 'personify-pro' );
                $demo['image']  = get_template_directory_uri() . '/assets/uploads/jake.jpg';

                // Push to the main array.
                array_push( $content, $demo );
            break;

            case 'custom':
                $custom['firstname']  = ! empty( $options['introduction_firstname'] ) ? $options['introduction_firstname'] : '';
                $custom['lastname']   = ! empty( $options['introduction_lastname'] ) ? $options['introduction_lastname'] : '';
                $custom['profession'] = ! empty( $options['introduction_profession'] ) ? $options['introduction_profession'] : '';
                $custom['excerpt']    = ! empty( $options['introduction_short_description'] ) ? $options['introduction_short_description'] : '';
                $custom['image']  = ! empty( $options['introduction_image'] ) ? $options['introduction_image'] : '';

                // Push to the main array.
                array_push( $content, $custom );
            break;

            case 'page':
                $page_id = ! empty( $options['introduction_content_page'] ) ? $options['introduction_content_page'] : '';
                $args = array(
                    'post_type'         => 'page',
                    'page_id'           => $page_id,
                    'posts_per_page'    => 1,
                    );                    
            break;

            case 'post':
                $post_id = ! empty( $options['introduction_content_post'] ) ? $options['introduction_content_post'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'p'                 => $post_id,
                    'posts_per_page'    => 1,
                    'ignore_sticky_posts' => true,
                    );
            break;

            default:
            break;
        }

        if ( in_array( $introduction_content_type, array( 'page', 'post' ) ) ) {

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    if ( true === $options['introduction_title_break'] ) :
                        $title = explode( ' ', get_the_title() );
                        $first_word = $title[0];
                        $title = implode( ' ', array_slice( $title, 1 ) );
                        $page_post['firstname']     = $first_word;
                        $page_post['lastname']      = $title;
                    else :
                        $page_post['firstname']     = get_the_title();
                        $page_post['lastname']      = '';
                    endif;
                    
                    $page_post['profession']    = '';
                    $page_post['excerpt']       = personify_pro_trim_content( 17 );
                    $page_post['url']           = get_the_permalink();
                    $page_post['image']         = get_the_post_thumbnail_url( '', 'full' );

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();

        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// Introduction Section content details.
add_filter( 'personify_pro_filter_introduction_section_details', 'personify_pro_get_introduction_section_details' );


if ( ! function_exists( 'personify_pro_render_introduction_section' ) ) :
  /**
   * Start Introduction Section
   *
   * @return string about content
   * @since Personify Pro 1.0
   *
   */
   function personify_pro_render_introduction_section( $content_details = array() ) {
        $options    = personify_pro_get_theme_options();
        $read_more  = ! empty( $options['read_more_text'] ) ? $options['read_more_text'] : esc_html__( 'Read More', 'personify-pro' );
        $class      = ( in_array( $options['introduction_content_type'] ,  array( 'page', 'post' ) ) && false === $options['introduction_title_break'] ) ? 'post-content' : '';
        $class      .= ( 'left' == $options['introduction_image_align'] ) ? ' image-left' : '';

        if ( empty( $content_details ) ) {
            return;
        }  

        foreach ( $content_details as $content ):
            $class .= ( empty( $content['image'] ) ) ? ' no-post-thumbnail' : ''; ?>
	    	<div id="hero-section" class="relative <?php echo esc_attr( $class ); ?>">
	            <div class="wrapper">
	                <div class="section-content">
	                    <article id="post-01" class="hentry">
	                        <div class="entry-summary">

	                            <header class="entry-header">
	                                <h2 class="entry-title">
	                                	<?php if ( ! empty( $content['firstname'] ) ) : ?>
		                                    <span class="first-name"><?php echo esc_html( $content['firstname'] ); ?></span> 
		                                <?php endif; 
		                                if ( ! empty( $content['lastname'] ) ) : ?>
		                                    <span class="last-name"><?php echo esc_html( $content['lastname'] ); ?></span>
		                                <?php endif; ?>
	                                </h2>
		                            <?php if ( ! empty( $content['profession'] ) ) : ?>
		                                <span class="designation"><?php echo esc_html( $content['profession'] ); ?></span>
		                            <?php endif; ?>
	                            </header>

	                            <?php if ( ! empty( $content['excerpt'] ) ) : ?>
		                            <div class="entry-description">
		                                <div class="separator"></div>
		                                <div class="entry-content small-description"><?php echo wp_kses_post( $content['excerpt'] ); ?></div><!-- .entry-content -->

                                        <?php if ( in_array( $options['introduction_content_type'] ,  array( 'page', 'post' ) ) ) : ?>
                                            <span class="read-more">
                                                <a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $read_more ); ?></a>
                                            </span>
                                        <?php endif; ?>
		                            </div><!-- .entry-description -->
		                        <?php endif; ?>

	                        </div><!-- .entry-summary -->
	                        <?php if ( ! empty( $content['image'] ) ) : ?>
		                        <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
		                        </div><!-- .featured-image -->
		                    <?php endif; ?>
	                    </article><!-- .hentry -->
	                </div><!-- .section-content -->
	            </div><!-- .wrapper -->
	        </div><!-- #hero-section -->
        <?php endforeach; 
    }
endif;
