<?php
/**
 * Journey section
 *
 * This is the template for the content of journey section
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */
if ( ! function_exists( 'personify_pro_add_journey_section' ) ) :
    /**
    * Add journey section
    *
    *@since Personify Pro 1.0
    */
    function personify_pro_add_journey_section() {
        // Check if journey is enabled on frontpage
        $journey_enable = apply_filters( 'personify_pro_section_status', true, 'journey_section_enable' );

        if ( true !== $journey_enable ) {
            return false;
        }
        // Get journey section details
        $section_details = array();
        $section_details = apply_filters( 'personify_pro_filter_journey_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render journey section now.
        personify_pro_render_journey_section( $section_details );
    }
endif;
add_action( 'personify_pro_primary_content', 'personify_pro_add_journey_section', 60 );


if ( ! function_exists( 'personify_pro_get_journey_section_details' ) ) :
    /**
    * journey section details.
    *
    * @since Personify Pro 1.0
    * @param array $input journey section details.
    */
    function personify_pro_get_journey_section_details( $input ) {
        $options = personify_pro_get_theme_options();

        // Content type.
        $journey_content_type  = $options['journey_content_type'];
        $content = array();
        switch ( $journey_content_type ) {
            case 'demo':
                $demo['title']      = esc_html__( 'My Journey', 'personify-pro' );
                $demo['url']        = '#';
                $demo['image']      = get_template_directory_uri() . '/assets/uploads/journey-01.jpg';
                $demo['excerpt']    = sprintf( '<p>%1$s</p> <p>%2$s</p>', esc_html__( 'Maecenas in orci enim. Maecenas eu nisl dapibus, blandit massa sed, sodales leo. Donec a semper velit. Duis sed porttitor urna, sit amet ullamcorper lorem. Nam enim ligula, dapibus at blandit sed, pharetra in lectus. Quisque tincidunt ipsum nec orci facilisis faucibus. Pellentesque ac cursus dui. Quisque lectus augue, dignissim ac tellus finibus, fringilla ultrices sem. Donec nibh erat, maximus a tristique ut, ornare in metus. Nunc consectetur erat velit, sit amet sagittis tellus luctus at. In hac habitasse platea dictumst.', 'personify-pro' ), esc_html__( 'Sed id lorem semper, iaculis ligula a, bibendum tortor. Cras non tempor mauris.Curabitur tristique magna vitae lorem venenatis, eu laoreet nisl ultricies. Phasellus lacinia vehicula tincidunt.', 'personify-pro' ) );

                // Push to the main array.
                array_push( $content, $demo );
            break;

            case 'custom':
                $custom['title']        = ! empty( $options['journey_title'] ) ? $options['journey_title'] : '';
                $custom['image']    = ! empty( $options['journey_featured_image'] ) ? $options['journey_featured_image'] : '';
                $custom['excerpt']      = ! empty( $options['journey_description'] ) ? $options['journey_description'] : '';

                // Push to the main array.
                array_push( $content, $custom );
            break;

            case 'page':
                $page_id = ! empty( $options['journey_content_page'] ) ? $options['journey_content_page'] : '';
                $args = array(
                    'post_type'         => 'page',
                    'page_id'           => $page_id,
                    'posts_per_page'    => 1,
                    );                    
            break;

            case 'post':
                $post_id = ! empty( $options['journey_content_post'] ) ? $options['journey_content_post'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'p'                 => $post_id,
                    'posts_per_page'    => 1,
                    );
            break;

            default:
            break;
        }

        if ( 'post' === $journey_content_type || 'page' === $journey_content_type ) {

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['title']     = get_the_title();
                    $page_post['image']     = get_the_post_thumbnail_url( '', 'large' );
                    $page_post['excerpt']   = wpautop( personify_pro_trim_content( 70 ) );
                    $page_post['url']       = get_the_permalink();

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();

        }

    if ( ! empty( $content ) ) {
        $input = $content;
    }
    return $input;
    }
endif;
// journey section content details.
add_filter( 'personify_pro_filter_journey_section_details', 'personify_pro_get_journey_section_details' );


if ( ! function_exists( 'personify_pro_render_journey_section' ) ) :
  /**
   * Start journey section
   *
   * @return string journey content
   * @since Personify Pro 1.0
   *
   */
   function personify_pro_render_journey_section( $content_details = array() ) {
        $options = personify_pro_get_theme_options();
        $journey_content_type  = $options['journey_content_type'];
        $read_more = ! empty( $options['read_more_text'] ) ? $options['read_more_text'] : esc_html__( 'Read More', 'personify-pro' );
        $featured_image = ! empty( $options['related_featured_image'] ) ? $options['related_featured_image'] : '';
        $featured_video = ! empty( $options['related_featured_video'] ) ? $options['related_featured_video'] : '';
        if ( empty( $content_details ) ) {
            return;
        } 

        foreach ( $content_details as $content ) : ?>
            <div id="journey" class="relative">
                <div class="wrapper">
                    <div class="section-content clear">
                        <div class="journey-description">
                            <article class="hentry <?php echo ( ! empty( $content['image'] ) ) ? 'has-post-thumbnail' : 'no-post-thumbnail'; ?>">
                                <div class="entry-container">

                                    <?php if ( ! empty( $content['title'] ) ) : ?>
                                    <header class="entry-header">
                                        <?php  
                                            $title = explode( ' ', $content['title'] );
                                            $first_word = $title[0];
                                            $title = implode( ' ', array_slice( $title, 1 ) );
                                        ?>
                                        <h2 class="entry-title"><span><?php echo esc_html( $first_word ); ?></span> <?php echo esc_html( $title ); ?></h2>
                                    </header>
                                    <?php endif; 

                                    if ( ! empty( $content['excerpt'] ) ) : ?>
                                        <div class="entry-content">
                                            <?php echo wp_kses_post( $content['excerpt'] ); ?>
                                        </div><!-- .entry-content -->
                                    <?php endif; 

                                    if ( in_array( $journey_content_type, array( 'post', 'page', 'demo' ) ) ) : ?>
                                        <span class="read-more">
                                            <a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $read_more ); ?></a>
                                        </span><!--- .read-more -->
                                    <?php endif; ?>
                                </div><!-- .entry-container -->

                                <?php if ( ! empty( $content['image'] ) ) : ?>
                                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                    </div><!-- .featured-image -->
                                <?php endif; ?>
                            </article>
                        </div><!-- .journey-description -->

                        <?php if ( true === $options['related_media_enable'] ) : ?>
                            <div class="video-wrap-section col-<?php echo ( ! empty( $featured_image ) && ! empty( $featured_video ) ) ? 2 : 1; ?>">
                                <?php if ( ! empty( $featured_image ) ) : ?>
                                    <div class="column-wrapper">
                                        <div class="featured-image" style="background-image: url('<?php echo esc_url( $featured_image ); ?>');">
                                        </div><!-- .featured-image -->
                                    </div><!-- .column-wrapper -->
                                <?php endif; 
                                if ( ! empty( $featured_video ) ) : 
                                    $library_video =  attachment_url_to_postid( $featured_video );
                                    ?>
                                    <div class="column-wrapper">
                                        <div class="featured-video-wrap">
                                            <?php 
                                            if ( 0 !== $library_video ) :
                                                the_widget( 'WP_Widget_Media_Video', $instance = array( 'attachment_id' => absint( $library_video ) ) ); 
                                            else :
                                                the_widget( 'WP_Widget_Media_Video', $instance = array( 'url' => esc_url( $featured_video ) ) ); 
                                            endif;
                                            ?>
                                        </div><!-- .featured-video -->
                                    </div><!-- .column-wrapper -->
                                <?php endif; ?>
                            </div><!-- .video-wrap -->
                        <?php endif; ?>
                    </div><!-- .section-content -->  
                </div><!-- .wrapper -->
            </div><!-- #journey -->
        <?php  endforeach;
    }
endif;