<?php
/**
 * Message section
 *
 * This is the template for the content of message section
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */
if ( ! function_exists( 'personify_pro_add_message_section' ) ) :
    /**
    * Add message section
    *
    *@since Personify Pro 1.0
    */
    function personify_pro_add_message_section() {
        // Check if message is enabled on frontpage
        $message_enable = apply_filters( 'personify_pro_section_status', true, 'message_section_enable' );

        if ( true !== $message_enable ) {
            return false;
        }
        // Get message section details
        $section_details = array();
        $section_details = apply_filters( 'personify_pro_filter_message_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render message section now.
        personify_pro_render_message_section( $section_details );
    }
endif;
add_action( 'personify_pro_primary_content', 'personify_pro_add_message_section', 70 );


if ( ! function_exists( 'personify_pro_get_message_section_details' ) ) :
    /**
    * message section details.
    *
    * @since Personify Pro 1.0
    * @param array $input message section details.
    */
    function personify_pro_get_message_section_details( $input ) {
        $options = personify_pro_get_theme_options();

        // Content type.
        $message_content_type  = $options['message_content_type'];

        $content = array();
        switch ( $message_content_type ) {
            case 'demo':
                $demo['excerpt']    = esc_html__( '"I hope that when the world comes to an end, I can breathe a sigh of relief, because there will be so much to look forward to."', 'personify-pro' );

                // Push to the main array.
                array_push( $content, $demo );
            break;

            case 'custom':
                $custom['excerpt']    = ! empty( $options['message_content_custom'] ) ? $options['message_content_custom'] : '';

                // Push to the main array.
                array_push( $content, $custom );
            break;

            case 'post':
                $post_id = ! empty( $options['message_content_post'] ) ? $options['message_content_post'] : '';
                $args = array(
                    'post_type'             => 'post',
                    'p'                     => absint( $post_id ),
                    'posts_per_page'        => 1,
                    );
            break;

            case 'page':
                $page_id = ! empty( $options['message_content_page'] ) ? $options['message_content_page'] : '';
                $args = array(
                    'post_type'         => 'page',
                    'page_id'           => $page_id,
                    'posts_per_page'    => 1,
                    );
            break;

            default:
            break;
        }

        if (  in_array( $message_content_type, array( 'post', 'page' ) ) ) {

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['excerpt']   = get_the_content();

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();

        }

    if ( ! empty( $content ) ) {
        $input = $content;
    }
    return $input;
    }
endif;
// message section content details.
add_filter( 'personify_pro_filter_message_section_details', 'personify_pro_get_message_section_details' );


if ( ! function_exists( 'personify_pro_render_message_section' ) ) :
  /**
   * Start message section
   *
   * @return string message content
   * @since Personify Pro 1.0
   *
   */
   function personify_pro_render_message_section( $content_details = array() ) {
        $options = personify_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        }
        foreach ( $content_details as $content ) : ?>
            <div id="section-promotion" class="relative page-section">
                <div class="wrapper">
                    <div class="entry-content">
                        <p class="description">
                            <?php echo wp_kses_post( $content['excerpt'] ); ?>
                        </p>
                    </div><!-- .entry-content -->
                    <div class="separator"></div>
                </div><!-- .wrapper -->
            </div><!-- #section-promotion -->
        <?php endforeach; 
    }
endif;