<?php
/**
 * Quotation section
 *
 * This is the template for the content of quotation section
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */
if ( ! function_exists( 'personify_pro_add_quotation_section' ) ) :
    /**
    * Add quotation section
    *
    *@since Personify Pro 1.0
    */
    function personify_pro_add_quotation_section() {
        // Check if quotation is enabled on frontpage
        $quotation_enable = apply_filters( 'personify_pro_section_status', true, 'quotation_section_enable' );

        if ( true !== $quotation_enable ) {
            return false;
        }
        // Get quotation section details
        $section_details = array();
        $section_details = apply_filters( 'personify_pro_filter_quotation_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render quotation section now.
        personify_pro_render_quotation_section( $section_details );
    }
endif;
add_action( 'personify_pro_primary_content', 'personify_pro_add_quotation_section', 40 );


if ( ! function_exists( 'personify_pro_get_quotation_section_details' ) ) :
    /**
    * quotation section details.
    *
    * @since Personify Pro 1.0
    * @param array $input quotation section details.
    */
    function personify_pro_get_quotation_section_details( $input ) {
        $options = personify_pro_get_theme_options();

        // Content type.
        $quotation_content_type  = $options['quotation_content_type'];
        $quotation_count  = ! empty( $options['quotation_count'] ) ? $options['quotation_count'] : 3;

        $content = array();
        switch ( $quotation_content_type ) {
            case 'demo':
                for ( $i = 1; $i <= 3; $i++ ) {
                    $demo['excerpt']    = esc_html__( 'Being a star doesn\'t last. That\'s not what life should be about. It\'s a complete illusion that really has nothing to do with you. For me, finding out about life is the most important thing.', 'personify-pro' );

                    // Push to the main array.
                    array_push( $content, $demo );
                }
            break;

            case 'custom':
                for ( $i = 1; $i <= $quotation_count; $i++ ) {
                    if ( ! empty( $options['quotation_content_custom_' . $i] ) ) :
                        $custom['excerpt']    = $options['quotation_content_custom_' . $i];

                        // Push to the main array.
                        array_push( $content, $custom );
                    endif;
                }
            break;

            case 'category':
                $cat_id = ! empty( $options['quotation_content_category'] ) ? $options['quotation_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'cat'               => absint( $cat_id ),
                    'posts_per_page'    => absint( $quotation_count ),
                    );                    
            break;

            case 'post':
                $post_id = ! empty( $options['quotation_content_post'] ) ? $options['quotation_content_post'] : '';
                $args = array(
                    'post_type'             => 'post',
                    'orderby'               => 'post__in',
                    'post__in'              => $post_id,
                    'posts_per_page'        => count( $post_id ),
                    'ignore_sticky_posts'   => true,
                    );
            break;

            case 'page':
                $page_id = array();

                for ( $i = 1; $i <= $quotation_count; $i++ ) {
                    if ( ! empty( $options['quotation_content_page' . $i] ) ) :
                        $page_id[]  = $options['quotation_content_page' . $i];
                    endif;
                }
                $args = array(
                    'post_type'         => 'page',
                    'orderby'           => 'post__in',
                    'post__in'          => $page_id,
                    'posts_per_page'    => count( $page_id ),
                    );
            break;

            default:
            break;
        }

        if (  in_array( $quotation_content_type, array( 'post', 'page', 'category' ) ) ) {

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['excerpt']   = get_the_content();
                    
                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();

        }

    if ( ! empty( $content ) ) {
        $input = $content;
    }
    return $input;
    }
endif;
// quotation section content details.
add_filter( 'personify_pro_filter_quotation_section_details', 'personify_pro_get_quotation_section_details' );


if ( ! function_exists( 'personify_pro_render_quotation_section' ) ) :
  /**
   * Start quotation section
   *
   * @return string quotation content
   * @since Personify Pro 1.0
   *
   */
   function personify_pro_render_quotation_section( $content_details = array() ) {
        $options = personify_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>
            <div id="feedback-section" class="relative page-section">
                <div class="wrapper">
                    <div class="section-content">
                        <?php echo personify_pro_get_svg( array( 'icon' => 'quote' ) ); ?>
                        <div class="speaker-quote" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": true, "speed": 1200, "dots": true, "arrows":false, "autoplay": true, "fade": false, "draggable": true }'>
                             <?php foreach ( $content_details as $content ) : ?>
                                <div class="slick-item">
                                    <div class="entry-content">
                                        <?php echo wp_kses_post( $content['excerpt'] ); ?>
                                    </div><!-- .entry-content -->
                                </div><!-- .slick-item -->
                            <?php endforeach; ?>
                        </div><!-- .regular -->
                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div><!-- #feedback-section -->
    <?php }
endif;