<?php
/**
 * Subscription Section
 *
 * This is the template for the content of Subscription Section
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */
if ( ! function_exists( 'personify_pro_add_subscription_section' ) ) :
    /**
    * Add Subscription Section
    *
    *@since Personify Pro 1.0
    */
    function personify_pro_add_subscription_section() {
        // Check if subscription is enabled on frontpage
        $subscription_enable = apply_filters( 'personify_pro_section_status', true, 'subscription_section_enable' );

        if ( true !== $subscription_enable ) {
            return false;
        }

        // Render Subscription Section now.
        personify_pro_render_subscription_section();
    }
endif;
add_action( 'personify_pro_footer_content', 'personify_pro_add_subscription_section', 20 );


if ( ! function_exists( 'personify_pro_render_subscription_section' ) ) :
    /**
    * Start Subscription Section
    *
    * @return string subscription content
    * @since Personify Pro 1.0
    *
    */
    function personify_pro_render_subscription_section() {
        $options    = personify_pro_get_theme_options();
        $title      = ! empty( $options['subscription_title'] ) ? $options['subscription_title'] : '';

        if ( ! class_exists( 'Jetpack' ) ) {
            return;
        } elseif ( class_exists( 'Jetpack' ) ) {
            if ( ! Jetpack::is_module_active( 'subscriptions' ) )
                return;
        } ?>
        <div id="subscribe-newsletter" class="relative">
                <div class="wrapper">
                    
                    <?php 
                        $subscription_shortcode = '[jetpack_subscription_form title="' . esc_html( $title ) . '" subscribe_text="" subscribe_button="' . esc_html__( 'Go', 'personify-pro' ) . '" show_subscribers_total="1"]';
                        echo do_shortcode( wp_kses_post( $subscription_shortcode ) ); 
                    ?>

                </div><!-- .wrapper -->
            </div><!-- #subscribe-newsletter -->
	<?php }
endif;
