<?php
/**
 * Testimonial section
 *
 * This is the template for the content of testimonial section
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */
if ( ! function_exists( 'personify_pro_add_testimonial_section' ) ) :
    /**
    * Add testimonial section
    *
    *@since Personify Pro 1.0
    */
    function personify_pro_add_testimonial_section() {
        // Check if testimonial is enabled on frontpage
        $testimonial_enable = apply_filters( 'personify_pro_section_status', true, 'testimonial_section_enable' );

        if ( true !== $testimonial_enable ) {
            return false;
        }
        // Get testimonial section details
        $section_details = array();
        $section_details = apply_filters( 'personify_pro_filter_testimonial_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render testimonial section now.
        personify_pro_render_testimonial_section( $section_details );
    }
endif;
add_action( 'personify_pro_primary_content', 'personify_pro_add_testimonial_section', 90 );


if ( ! function_exists( 'personify_pro_get_testimonial_section_details' ) ) :
    /**
    * testimonial section details.
    *
    * @since Personify Pro 1.0
    * @param array $input testimonial section details.
    */
    function personify_pro_get_testimonial_section_details( $input ) {
        $options = personify_pro_get_theme_options();

        // Content type.
        $testimonial_content_type  = $options['testimonial_content_type'];
        $testimonial_count  = ! empty( $options['testimonial_count'] ) ? $options['testimonial_count'] : 3;

        $content = array();
        switch ( $testimonial_content_type ) {
            case 'demo':
                $title = array(
                    1 => esc_html( 'Mike Demien', 'personify-pro' ),
                    2 => esc_html( 'Charlize Theron', 'personify-pro' ),
                    3 => esc_html( 'Jake Manison', 'personify-pro' ),
                    );
                $sub_title = array(
                    1 => esc_html( 'Great Fan', 'personify-pro' ),
                    2 => esc_html( 'Actress', 'personify-pro' ),
                    3 => esc_html( 'Director', 'personify-pro' ),
                    );
                for ( $i = 1; $i <= 3; $i++ ) {
                    $demo['title']      = $title[$i];
                    $demo['sub_title']  = $sub_title[$i];
                    $demo['url']        = '#';
                    $demo['image']      = get_template_directory_uri() . '/assets/uploads/testimonial-0' . $i . '.jpg';
                    $demo['excerpt']    = esc_html__( 'He is so inspiring to me that Nam aliquam vestibulum lacus. Sed pretium quis eros a pellentesque. Proin eu consectetur. Donec posuere arcu tincidunt neque.', 'personify-pro' );

                    // Push to the main array.
                    array_push( $content, $demo );
                }
            break;

            case 'custom':
                for ( $i = 1; $i <= $testimonial_count; $i++ ) {
                    $custom['title']        = ! empty( $options['testimonial_content_title_' . $i] ) ? $options['testimonial_content_title_' . $i] : '';
                    $custom['sub_title']    = ! empty( $options['testimonial_content_sub_title_' . $i] ) ? $options['testimonial_content_sub_title_' . $i] : '';
                    $custom['excerpt']      = ! empty( $options['testimonial_content_description_' . $i] ) ? $options['testimonial_content_description_' . $i] : '';
                    $custom['image']        = ! empty( $options['testimonial_content_image_' . $i] ) ? $options['testimonial_content_image_' . $i] : '';
                    $custom['url']          = '';

                    // Push to the main array.
                    array_push( $content, $custom );
                }
            break;

            case 'category':
                $cat_id = ! empty( $options['testimonial_content_category'] ) ? $options['testimonial_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'cat'               => absint( $cat_id ),
                    'posts_per_page'    => absint( $testimonial_count ),
                    );                    
            break;

            case 'post':
                $post_id = ! empty( $options['testimonial_content_post'] ) ? $options['testimonial_content_post'] : '';
                $args = array(
                    'post_type'             => 'post',
                    'orderby'               => 'post__in',
                    'post__in'              => $post_id,
                    'posts_per_page'        => count( $post_id ),
                    'ignore_sticky_posts'   => true,
                    );
            break;

            case 'page':
                $page_id = array();

                for ( $i = 1; $i <= $testimonial_count; $i++ ) {
                    if ( ! empty( $options['testimonial_content_page_' . $i] ) ) :
                        $page_id[]  = $options['testimonial_content_page_' . $i];
                    endif;
                }
                $args = array(
                    'post_type'         => 'page',
                    'orderby'           => 'post__in',
                    'post__in'          => $page_id,
                    'posts_per_page'    => count( $page_id ),
                    );
            break;

            default:
            break;
        }

        if (  in_array( $testimonial_content_type, array( 'post', 'page', 'category' ) ) ) {

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['title']     = get_the_title();
                    $page_post['sub_title'] = '';
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = wpautop( personify_pro_trim_content( 25 ) );
                    $page_post['image']     = get_the_post_thumbnail_url( '', 'thumbnail' );

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();

        }

    if ( ! empty( $content ) ) {
        $input = $content;
    }
    return $input;
    }
endif;
// testimonial section content details.
add_filter( 'personify_pro_filter_testimonial_section_details', 'personify_pro_get_testimonial_section_details' );


if ( ! function_exists( 'personify_pro_render_testimonial_section' ) ) :
  /**
   * Start testimonial section
   *
   * @return string testimonial content
   * @since Personify Pro 1.0
   *
   */
   function personify_pro_render_testimonial_section( $content_details = array() ) {
        $options = personify_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>
        <div id="client-testimonial" class="relative page-section">
            <div class="wrapper">
                <?php if ( ! empty( $options['testimonial_title'] ) ) : ?>
                    <div class="section-header align-center">
                        <?php  
                            $title = explode( ' ', $options['testimonial_title'] );
                            $first_word = $title[0];
                            $title = implode( ' ', array_slice( $title, 1 ) );
                        ?>
                        <h2 class="section-title"><span><?php echo esc_html( $first_word ); ?></span> <?php echo esc_html( $title ); ?></h2>
                    </div><!-- .section-header -->
                <?php endif; ?>
                <div class="section-content">
                    <div class="testimonial-slider <?php echo ( count( $content_details ) === 1 ) ? 'one-item' : ''; ?>" data-slick='{"slidesToShow": <?php echo ( count( $content_details ) === 1 ) ? 1 : 2; ?>, "slidesToScroll": 1, "infinite": true, "speed": 1000, "dots": false, "arrows":true, "autoplay": true, "fade": false, "draggable": true }'>
                        <?php foreach ( $content_details as $content ) : ?>
                            <div class="slick-item">
                                <div class="client-wrapper">
                                    <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/uploads/quote-gray.png' ); ?>" class="quote-icon" alt="<?php echo esc_attr( $content['title'] ); ?>">

                                    <?php if ( ! empty( $content['excerpt'] ) ) : ?>
                                        <div class="entry-content"><?php echo wp_kses_post( $content['excerpt'] ); ?></div><!-- .entry-content -->
                                    <?php endif; 

                                    if ( ! empty( $content['title'] ) ) : ?>
                                        <header class="entry-header">
                                            <h2 class="entry-title">
                                                <?php if ( ! empty( $content['url'] ) ) : ?>
                                                    <a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a>
                                                <?php else : 
                                                    echo esc_html( $content['title'] );
                                                endif; ?>
                                            </h2>
                                        </header>
                                    <?php endif;

                                    if ( ! empty( $content['sub_title'] ) ) : ?>
                                        <div class="client-meta">
                                            <span class="designation"><?php echo esc_html( $content['sub_title'] ); ?></span>
                                        </div><!-- .client-meta -->
                                    <?php endif; 

                                    if ( ! empty( $content['image'] ) ) : ?>
                                        <div class="featured-image">
                                            <img src="<?php echo esc_url( $content['image'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>">
                                        </div><!-- .featured-image -->
                                    <?php endif; ?>
                                </div><!-- .client-wrapper -->
                            </div><!-- .slick-item -->
                        <?php endforeach; ?>
                    </div><!-- .testimonial-slider -->
                </div><!-- .section-content -->
            </div><!-- .wrapper -->
        </div><!-- #client-testimonial -->
    <?php }
endif;