<?php
/**
 * Featured Video Section
 *
 * This is the template for the content of Featured Video Section
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */
if ( ! function_exists( 'personify_pro_add_video_section' ) ) :
    /**
    * Add Featured Video Section
    *
    *@since Personify Pro 1.0
    */
    function personify_pro_add_video_section() {
        // Check if video is enabled on frontpage
        $video_enable = apply_filters( 'personify_pro_section_status', true, 'video_section_enable' );

        if ( true !== $video_enable ) {
            return false;
        }

        // Render Featured Video Section now.
        personify_pro_render_video_section();
    }
endif;
add_action( 'personify_pro_primary_content', 'personify_pro_add_video_section', 50 );


if ( ! function_exists( 'personify_pro_render_video_section' ) ) :
  /**
   * Start Featured Video Section
   *
   * @return string video content
   * @since Personify Pro 1.0
   *
   */
   function personify_pro_render_video_section() {
        $options        = personify_pro_get_theme_options();
        $featured_video = ! empty( $options['video_section_url'] ) ? $options['video_section_url'] : ''; 
        if ( empty( $featured_video ) ) {
            return;
        } 

        $library_video =  attachment_url_to_postid( $featured_video );
        ?>
        <div id="video-wrapper" class="relative" style="background-color: #f4f5f6;">
            <div class="wrapper">
            <?php 
            if ( 0 !== $library_video ) :
                the_widget( 'WP_Widget_Media_Video', $instance = array( 'attachment_id' => absint( $library_video ) ) ); 
            else :
                the_widget( 'WP_Widget_Media_Video', $instance = array( 'url' => esc_url( $featured_video ) ) ); 
            endif;
            ?>
            </div><!-- .wrapper -->
        </div><!-- #video-wrapper -->
	<?php }
endif;
