<?php
/**
 * Theme Palace basic theme structure hooks
 *
 * This file contains structural hooks.
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

$options = personify_pro_get_theme_options();


if ( ! function_exists( 'personify_pro_doctype' ) ) :
	/**
	 * Doctype Declaration.
	 *
	 * @since Personify Pro 1.0
	 */
	function personify_pro_doctype() {
	?>
		<!DOCTYPE html>
			<html <?php language_attributes(); ?>>
	<?php
	}
endif;

add_action( 'personify_pro_doctype', 'personify_pro_doctype', 10 );


if ( ! function_exists( 'personify_pro_head' ) ) :
	/**
	 * Header Codes
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_head() {
		?>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		<link rel="profile" href="http://gmpg.org/xfn/11">
		<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
			<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
		<?php endif;
	}
endif;
add_action( 'personify_pro_before_wp_head', 'personify_pro_head', 10 );

if ( ! function_exists( 'personify_pro_page_start' ) ) :
	/**
	 * Page starts html codes
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_page_start() {
		?>
		<div id="page" class="site">
			<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'personify-pro' ); ?></a>

		<?php
	}
endif;

add_action( 'personify_pro_page_start_action', 'personify_pro_page_start', 10 );

if ( ! function_exists( 'personify_pro_page_end' ) ) :
	/**
	 * Page end html codes
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_page_end() {
		?>
		</div><!-- #page -->
		<?php
	}
endif;
add_action( 'personify_pro_page_end_action', 'personify_pro_page_end', 10 );

if ( ! function_exists( 'personify_pro_header_start' ) ) :
	/**
	 * Header start html codes
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_header_start() {
		$options = personify_pro_get_theme_options();
		?>
		<header id="masthead" class="site-header <?php echo ( true === $options['menu_sticky'] ) ? 'sticky-header' : ''; ?>" role="banner">
		<?php
	}
endif;
add_action( 'personify_pro_header_action', 'personify_pro_header_start', 10 );

if ( ! function_exists( 'personify_pro_site_branding' ) ) :
	/**
	 * Site branding codes
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_site_branding() {
		$options  = personify_pro_get_theme_options();
		$header_txt_logo_extra = $options['header_txt_logo_extra'];		
		?>
		<div class="site-branding">
			<?php 
			if ( 'show-all' === $header_txt_logo_extra  || 'logo-only' === $header_txt_logo_extra || 'logo-title' === $header_txt_logo_extra || 'logo-tagline' === $header_txt_logo_extra ) {
				the_custom_logo();
			} ?>
			<div id="site-details">
			<?php if( 'show-all' === $header_txt_logo_extra  || 'title-only' === $header_txt_logo_extra || 'logo-title' === $header_txt_logo_extra ) {
				if ( is_front_page() && is_home() ) : ?>
					<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
				<?php else : ?>
					<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
				<?php
				endif;
			} 
			if ( 'show-all' === $header_txt_logo_extra  || 'tagline-only' === $header_txt_logo_extra || 'logo-tagline' === $header_txt_logo_extra ) {
				$description = get_bloginfo( 'description', 'display' );
				if ( $description || is_customize_preview() ) : ?>
					<p class="site-description"><?php echo esc_html($description); /* WPCS: xss ok. */ ?></p>
				<?php
				endif; 
			}?>
			</div><!-- #site-details -->
		</div><!-- .site-branding -->
		<?php
	}
endif;
add_action( 'personify_pro_header_action', 'personify_pro_site_branding', 20 );

if ( ! function_exists( 'personify_pro_site_navigation' ) ) :
	/**
	 * Site navigation codes
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_site_navigation() {
		$options = personify_pro_get_theme_options();
		?>
		<nav id="site-navigation" class="main-navigation" role="navigation" aria-label="Primary Menu">
			<button class="menu-toggle <?php echo ( false === $options['menu_label_enable'] ) ? 'menu-label-disabled' : ''; ?>" aria-controls="primary-menu" aria-expanded="false">
				<?php
				echo personify_pro_get_svg( array( 'icon' => 'menu' ) );
				echo personify_pro_get_svg( array( 'icon' => 'close' ) );
				if ( true === $options['menu_label_enable'] ) :
					echo '<span class="menu-label">' . esc_html__( 'Menu', 'personify-pro' ) . '</span>';
				endif;
				?>					
			</button>
			<?php wp_nav_menu( array( 
				'fallback_cb'=>'personify_pro_menu_fallback_cb', 
				'theme_location' 	=> 'primary', 
				'menu_id' 			=> 'primary-menu',
				'menu_class' 		=> 'menu nav-menu',
			) ); ?>
		</nav><!-- #site-navigation -->
		<?php
	}
endif;
add_action( 'personify_pro_header_action', 'personify_pro_site_navigation', 30 );

if ( ! function_exists( 'personify_pro_header_menu_search' ) ) :
	/**
	 * primary menu search
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_header_menu_search() {
		$output = '<a href="#" class="search">';
		$output .= personify_pro_get_svg( array( 'icon' => 'search' ) );
		$output .= personify_pro_get_svg( array( 'icon' => 'close' ) );
        $output .= '</a>';
        $output .= '<div id="search">';
        $output .= get_search_form( false );
        $output .= '</div>';
        return $output;
	}
endif;

if ( ! function_exists( 'personify_pro_add_nav_search' ) ) :
	/**
	 * primary menu search concatinate 
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_add_nav_search($items, $args) {
	  	if ( $args->theme_location == 'primary' ) {
	        $items = $items;
	        $items .= '<li>'. personify_pro_header_menu_search() .'</li>';
	        return $items;
	  	}
	  	return $items;
	}
endif;
add_filter( 'wp_nav_menu_items', 'personify_pro_add_nav_search', 10, 2 );

if ( ! function_exists( 'personify_pro_header_end' ) ) :
	/**
	 * Header end html codes
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_header_end() {
		?>
		</header><!-- #masthead -->
		<?php
	}
endif;

add_action( 'personify_pro_header_action', 'personify_pro_header_end', 50 );

if ( ! function_exists( 'personify_pro_content_start' ) ) :
	/**
	 * Site content codes
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_content_start() {
		?>
		<div id="content" class="site-content">
		<?php
	}
endif;
add_action( 'personify_pro_content_start_action', 'personify_pro_content_start', 10 );

if ( ! function_exists( 'personify_pro_content_end' ) ) :
	/**
	 * Site content codes
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_content_end() {
		?>
		</div><!-- #content -->
		<?php
	}
endif;
add_action( 'personify_pro_content_end_action', 'personify_pro_content_end', 10 );

if ( ! function_exists( 'personify_pro_footer_start' ) ) :
	/**
	 * Footer starts
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_footer_start() {
		$count = 0;
		$support = get_theme_support( 'footer-widgets' );
		for ( $i = 1; $i <= absint( $support[0] ); $i++ ) {
			if ( is_active_sidebar( 'footer-' . $i ) ) {
				$count++;
			}
		}
		$count = ( $count > 0  ) ? 'footer-widget-active' : '';
		?>
		<footer id="colophon" class="site-footer <?php echo esc_attr( $count ); ?>" role="contentinfo">
		<?php
	}
endif;
add_action( 'personify_pro_footer', 'personify_pro_footer_start', 10 );

if ( ! function_exists( 'personify_pro_footer_detail_section' ) ) :
	/**
	 * Start div id #loader
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_footer_detail_section() { 
		$options = personify_pro_get_theme_options(); 
		if ( false === $options['footer_detail_enable'] ) {
			return;
		}

		if ( true === $options['footer_name_enable'] && ( ( has_nav_menu( 'footer' ) && true === $options['footer_menu_enable'] ) || ( has_nav_menu( 'social' ) && true === $options['footer_social_menu_enable'] ) ) ) {
			$col = 'col-2';
		} else {
			$col = 'col-1';
		}
		?>
		<div class="footer-widgets-area page-section footer-details <?php echo esc_attr( $col ); ?>">
                <div class="wrapper">
                	<?php if ( true === $options['footer_name_enable'] ) :
                		$firstname = ! empty( $options['footer_firstname'] ) ? $options['footer_firstname'] : '';
                		$lastname = ! empty( $options['footer_lastname'] ) ? $options['footer_lastname'] : '';
                	?>
	                    <div class="column-wrapper">
	                        <section id="text" class="widget widget_text">
	                            <div class="textwidget">
	                                <?php if ( ! empty( $firstname ) ) : ?>
		                                <span class="first-name"><?php echo esc_html( $firstname ); ?></span> 
		                            <?php endif; 

		                            if ( ! empty( $lastname ) ) : ?>
		                                <span class="last-name"><?php echo esc_html( $lastname ); ?></span>
		                            <?php endif; ?>
	                            </div><!-- .textwidget -->
	                        </section><!-- .widget_text -->
	                    </div><!-- .column-wrapper -->
	                <?php endif; 

	                if ( has_nav_menu( 'footer' ) && true === $options['footer_menu_enable'] || has_nav_menu( 'social' ) && true === $options['footer_social_menu_enable'] ) : ?>
	                    <div class="column-wrapper">
	                    	<?php if ( has_nav_menu( 'footer' ) && true === $options['footer_menu_enable'] ) : ?>
		                        <section id="nav_menu-1" class="widget widget_nav_menu">
		                            <div class="menu-footer-menu-1-container">
		                                <?php 
											wp_nav_menu( array(
												'theme_location' => 'footer',
												'menu_class'     => 'menu-footer-menu-1 menu',
												'depth'          => 1,
											) );
										?>
		                            </div><!-- .menu-footer-menu-1-container -->
		                        </section><!-- .widget_nav_menu -->
	                    	<?php endif; 

	                    	if ( has_nav_menu( 'social' ) && true === $options['footer_social_menu_enable'] ) : ?>
		                         <section id="nav_menu-2" class="widget widget_nav_menu">
		                            <div class="menu-footer-social-menu-1-container social-icons">
		                                <?php 
											wp_nav_menu( array(
												'theme_location' => 'social',
												'menu_class'     => 'social-links-menu',
												'depth'          => 1,
												'link_before'    => '<span class="screen-reader-text">',
												'link_after'     => '</span>' . personify_pro_get_svg( array( 'icon' => 'chain' ) ),
											) );
										?>
		                            </div>
		                        </section>
		                    <?php endif; ?>
	                    </div><!-- .column-wrapper -->
	                <?php endif; ?>
                </div><!-- .wrapper -->
            </div><!-- .footer-widgets-area -->
	<?php	
	}
endif;
add_action( 'personify_pro_footer', 'personify_pro_footer_detail_section', 20 );

if ( ! function_exists( 'personify_pro_footer_site_info' ) ) :
	/**
	 * Footer starts
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_footer_site_info() {
		$options = personify_pro_get_theme_options();
		$search = array( '[the-year]', '[site-link]' );

        $replace = array( date( 'Y' ), '<a href="'. esc_url( home_url( '/' ) ) .'">'. esc_attr( get_bloginfo( 'name', 'display' ) ) . '</a>' );

        $options['copyright_text'] = str_replace( $search, $replace, $options['copyright_text'] );
        $options['powered_by_text'] = str_replace( $search, $replace, $options['powered_by_text'] );

		$copyright_text = $options['copyright_text']; 
		$powered_by_text = $options['powered_by_text']; 
		?>
		<div class="site-info">
			<div class="wrapper">
				<p>
					<?php 
					echo personify_pro_santize_allow_tag( $copyright_text ); 
					if ( function_exists( 'the_privacy_policy_link' ) ) {
					    the_privacy_policy_link( '<span class="sep"> | </span>' );
					}
					?>
				</p>
				<p class="powered-by">
					<?php echo personify_pro_santize_allow_tag( $powered_by_text ); ?>
				</p>
			</div>
		</div><!-- .site-info -->
		<?php
	}
endif;
add_action( 'personify_pro_footer', 'personify_pro_footer_site_info', 30 );

if ( ! function_exists( 'personify_pro_footer_scroll_to_top' ) ) :
	/**
	 * Footer starts
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_footer_scroll_to_top() {
		$options  = personify_pro_get_theme_options();
		if ( true === $options['scroll_top_visible'] ) : ?>
			<div class="backtotop">
				<?php echo personify_pro_get_svg( array( 'icon' => 'up-arrow' ) ); ?>
			</div>
		<?php endif;
	}
endif;
add_action( 'personify_pro_footer', 'personify_pro_footer_scroll_to_top', 40 );

if ( ! function_exists( 'personify_pro_footer_end' ) ) :
	/**
	 * Footer starts
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_footer_end() {
		?>
		</footer>
		<?php
	}
endif;
add_action( 'personify_pro_footer', 'personify_pro_footer_end', 100 );

if ( ! function_exists( 'personify_pro_loader' ) ) :
	/**
	 * Start div id #loader
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_loader() {
		$options = personify_pro_get_theme_options();
		if ( $options['loader_enable'] ) { ?>
			<div id="loader">
				<div class="loader-container">
					<?php if ( 'default' == $options['loader_icon'] ) : ?>
						<div id="preloader">
		                    <span></span>
		                    <span></span>
		                    <span></span>
		                    <span></span>
		                    <span></span>
		                </div>
					<?php else :
						echo personify_pro_get_svg( array( 'icon' => esc_attr( $options['loader_icon'] ) ) ); 
					endif; ?>
				</div>	
			</div><!-- end loader -->
		<?php }
	}
endif;
add_action( 'personify_pro_before_header', 'personify_pro_loader', 10 );


if ( ! function_exists( 'personify_pro_add_breadcrumb' ) ) :

	/**
	 * Add breadcrumb.
	 *
	 * @since Personify Pro 1.0
	 */
	function personify_pro_add_breadcrumb() {
		$options = personify_pro_get_theme_options();

		// Bail if Breadcrumb disabled.
		if ( false === $options['breadcrumb_enable'] ) {
			return;
		}
		
		// Bail if Home Page.
		if ( is_front_page() && ! is_home() ) {
			return;
		}

		echo '<div id="breadcrumb-list">
			<div class="wrapper">';
				/**
				 * personify_pro_simple_breadcrumb hook
				 *
				 * @hooked personify_pro_simple_breadcrumb -  10
				 *
				 */
				do_action( 'personify_pro_simple_breadcrumb' );
		echo '</div><!-- .wrapper -->
			</div><!-- #breadcrumb-list -->';
		return;
	}

endif;
add_action( 'personify_pro_simple_breadcrumb_action', 'personify_pro_add_breadcrumb' , 10 );

if ( ! function_exists( 'personify_pro_related_posts' ) ) :
	/**
	 * related posts for single post
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_related_posts( $id = '' ) {
		$options = personify_pro_get_theme_options();

		if ( false === $options['single_post_show_related'] ) {
			return;
		}

		global $post;

		if ( empty( $id ) && is_object( $post ) ) {
			$id = $post->ID;
		}

		$categories = array();
		$cat_lists = get_the_category( $id );
		foreach ( $cat_lists as $cat_list ) :
			$categories[] = $cat_list->term_id;
		endforeach;
		$args = array( 
			'post_type'			=> 'post',
			'category__in'		=> $categories,
			'posts_per_page'	=> 4,
			'post__not_in'		=> ( array ) $id,
			);

		$query = new WP_Query( $args );

		if ( $query->have_posts() ) :
		?>
			<div id="related-posts">
                <h2 class="related-posts-title"><span><?php esc_html_e( 'Related', 'personify-pro' ); ?></span> <?php esc_html_e( 'Posts', 'personify-pro' ); ?></h2>

                <div class="related-posts-content col-4">
                    <?php while ( $query->have_posts() ) : $query->the_post(); ?>
	                    <article class="hentry">
	                    	<div class="black-overlay"></div>
	                        <header class="entry-header">
	                            <h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
	                        </header>

	                        <div class="featured-image">
	                        	<?php if ( has_post_thumbnail() ) : 
	                        		the_post_thumbnail( 'post-thumbnail', array( 'alt' => the_title_attribute( 'echo=0' ) ) ); 
                        		else : ?>
                        			<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/uploads/no-featured-image-295x400.jpg" alt="<?php echo esc_attr( get_the_title() ); ?>">
		                    	<?php endif; ?>
	                        </div><!-- .featured-image -->

	                        <div class="post-categories">
	                            <?php the_category(); ?>
	                        </div><!-- .post-categories -->
	                    </article>
	                <?php endwhile; ?>
                </div><!-- .related-posts-content -->
            </div><!-- #related-posts -->
		<?php 
		endif;
		wp_reset_postdata();
	}
endif;
add_action( 'personify_pro_related_posts_action', 'personify_pro_related_posts', 10 );

if ( ! function_exists( 'personify_pro_social_share' ) ) :

	/**
	 * Add social share.
	 *
	 * @since Personify Pro 1.0
	 */
	function personify_pro_social_share() {
		$options = personify_pro_get_theme_options();

		// Bail if Breadcrumb disabled.
		if ( false === $options['single_post_show_social'] || is_front_page() ) {
			return;
		} 
		$page = get_post_type();
		?>
		<div class="get-in-touch">
            <small><?php printf( esc_html__( 'Share This %s', 'personify-pro' ), ucwords( $page ) ); ?></small>
            <ul class="social-icons">
            	<?php if ( true === $options['single_post_show_facebook'] ) : ?>
	                <li>
	                	<a type="button" title="<?php esc_attr_e( 'Share on Facebook', 'personify-pro' ); ?>" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>">
	                		<span class="screen-reader-text"><?php esc_html_e( 'Facebook', 'personify-pro' ); ?></span>
	                		<?php echo personify_pro_get_svg( array( 'icon' => 'facebook' ) ); ?>
	                	</a>
	                </li>
	            <?php endif; 

	            if ( true === $options['single_post_show_twitter'] ) : ?>
	                <li>
	                	<a type="button" title="<?php esc_attr_e( 'Share on Twitter', 'personify-pro' ); ?>" target="_blank" href="https://twitter.com/share?url=<?php the_permalink(); ?>&text=<?php the_title(); ?>&via=">
	                		<span class="screen-reader-text"><?php esc_html_e( 'Twitter', 'personify-pro' ); ?></span>
	                		<?php echo personify_pro_get_svg( array( 'icon' => 'twitter' ) ); ?>
	                	</a>
	                </li>
	            <?php endif; 

	            if ( true === $options['single_post_show_google'] ) : ?>
	                <li>
	                	<a type="button" title="<?php esc_attr_e( 'Share on Google Plus', 'personify-pro' ); ?>" target="_blank" href="https://plus.google.com/share?url=<?php the_permalink(); ?>">
	                	<span class="screen-reader-text"><?php esc_html_e( 'Google Plus', 'personify-pro' ); ?></span>
	                		<?php echo personify_pro_get_svg( array( 'icon' => 'google-plus' ) ); ?>
	                	</a>
	                </li>
	            <?php endif; ?>
            </ul><!-- .social-icons -->
        </div><!-- .get-in-touch -->
	<?php }

endif;
add_action( 'personify_pro_single_social_share_action', 'personify_pro_social_share' , 10 );

if ( ! function_exists( 'personify_pro_get_author_profile' ) ) :
	/**
	 * Function to get author profile
	 *
	 * @since Personify Pro 1.0
	 */           
	function personify_pro_get_author_profile(){
		$options = personify_pro_get_theme_options();
		if ( false === $options['single_post_show_author'] ) {
			return;
		} ?>

		<article id="about-author">
		    <div class="admin-image">
		        <?php echo get_avatar( get_the_author_meta( 'ID' ), 150 );  ?>   
		        <div class="separator"></div>         
		    </div>

		    <div class="author-content">
		        <header class="entry-header">
		            <h2 class="entry-title">
		                <?php the_author_posts_link(); ?> 
		            </h2>
		        </header>
		        <span><?php esc_html_e( 'Author', 'personify-pro' ); ?></span>
		    </div><!-- .author-content -->   
		</article><!-- #about-author -->

	<?php
	}	
endif;
add_action( 'personify_pro_author_profile_action', 'personify_pro_get_author_profile' );

if ( ! function_exists( 'personify_pro_infinite_loader_spinner' ) ) :
	/**
	 *
	 * @since Personify Pro 1.0
	 *
	 */
	function personify_pro_infinite_loader_spinner() { 
		global $post;
		$options = personify_pro_get_theme_options();
		if ( $options['pagination_type'] == 'infinite' ) :
			if ( count( $post ) > 0 ) {
				echo '<div class="blog-loader">' . personify_pro_get_svg( array( 'icon' => 'spinner-umbrella' ) ) . '</div>';
			}
		endif;
	}
endif;
add_action( 'personify_pro_infinite_loader_spinner_action', 'personify_pro_infinite_loader_spinner', 10 );
