<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */
if ( ! function_exists( 'personify_pro_categories' ) ) :
	/**
	 * Prints HTML with meta information for the categories .
	 */
	function personify_pro_categories() {
		$options = personify_pro_get_theme_options();
		// Hide category for pages.
		if ( 'post' === get_post_type() ) {
			if ( is_singular( 'post' ) && true == $options['single_post_show_category'] ) :
				/* translators: used between list items, there is a space after the comma */
				$categories_list = get_the_category_list( ', ' );
				if ( $categories_list && personify_pro_categorized_blog() ) : ?>
					<?php 
						printf( '<span class="post-categories">' . '%1$s' . '</span>', $categories_list ); // WPCS: XSS OK.
					?>
				<?php endif;
			elseif( ( is_archive() || is_search() || is_home() ) && true === $options['show_category'] )  :
				/* translators: used between list items, there is a space after the comma */
				$categories_list = get_the_category_list( esc_html__( ', ', 'personify-pro' ) );
				if ( $categories_list && personify_pro_categorized_blog() ) : ?>
					<?php 
						printf( '<span class="post-categories">' . '%1$s' . '</span>', $categories_list ); // WPCS: XSS OK.
					?>
				<?php endif;
			endif;
		}
	}
endif;

if ( ! function_exists( 'personify_pro_posted_date' ) ) :
	/**
	 * Prints HTML with meta information for the current post-date/time .
	 */
	function personify_pro_posted_date() {
		$options = personify_pro_get_theme_options();
		if ( is_singular( 'post' ) && true == $options['single_post_show_date'] ) :
			// Finally, let's write all of this to the page.
			echo '<span class="posted-on">' . personify_pro_time_link() . '</span>';
		elseif ( ( is_archive() || is_search() || is_home() ) && true === $options['show_date'] ) :
			// Finally, let's write all of this to the page.
			echo '<span class="posted-on">' . personify_pro_time_link() . '</span>';
		endif;
	}
endif;

if ( ! function_exists( 'personify_pro_posted_on' ) ) :
	/**
	 * Prints HTML with meta information for the current post-date/time and categories.
	 */
	function personify_pro_posted_on() {
		
		personify_pro_posted_date();

		personify_pro_categories();
	}
endif;

if ( ! function_exists( 'personify_pro_author' ) ) :
	function personify_pro_author() {
		// Get the author name; wrap it in a link.
		$byline = sprintf(
			/* translators: %s: post author */
			__( 'by %s', 'personify-pro' ),
			'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . get_the_author() . '</a></span>'
		);

		echo '<span class="byline"> ' . $byline . '</span>';
	}
endif;


if ( ! function_exists( 'personify_pro_time_link' ) ) :
/**
 * Gets a nicely formatted string for the published date.
 */
function personify_pro_time_link() {
	$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
	if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
		$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
	}

	$time_string = sprintf( $time_string,
		get_the_date( DATE_W3C ),
		get_the_date(),
		get_the_modified_date( DATE_W3C ),
		get_the_modified_date()
	);

	$year  = get_the_time( 'Y', get_the_id() );
    $month = get_the_time( 'm', get_the_id() );

	// Wrap the time string in a link, and preface it with 'Posted on'.
	return sprintf(
		/* translators: %s: post date */
		__( '<span class="screen-reader-text">Posted on</span> %s', 'personify-pro' ),
		'<a href="' . esc_url( get_month_link( $year, $month ) ) . '" rel="bookmark">' . $time_string . '</a>'
	);

}
endif;

if ( ! function_exists( 'personify_pro_entry_footer' ) ) :
	/**
	 * Prints HTML with meta information for the categories, tags and comments.
	 */
	function personify_pro_entry_footer() {
		$options = personify_pro_get_theme_options();
		// Hide tag text for pages.
		if ( 'post' === get_post_type() ) {
			if ( is_singular( 'post' ) && true == $options['single_post_show_tags'] ) :
				/* translators: used between list items, there is a space after the comma */
				$tags_list = get_the_tag_list( '', ' ' );
				if ( $tags_list ) :
					echo '<span class="tags-links">' . $tags_list . '</span>'; // WPCS: XSS OK.
				endif;
			endif;
		}

		if ( true === $options['show_comments'] && ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			echo '<span class="comments-link">';
			/* translators: %s: post title */
			comments_popup_link( sprintf( wp_kses( __( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'personify-pro' ), array( 'span' => array( 'class' => array() ) ) ), get_the_title() ) );
			echo '</span>';
		}

	}
endif;

/**
 * Returns edit link for posts
 *
 * @return bool
 */
function personify_pro_edit_link() {
	edit_post_link(
			sprintf(
				/* translators: %s: Name of current post */
				esc_html__( 'Edit %s', 'personify-pro' ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			),
			'<p class="edit-link">',
			'</p>'
		);
}

/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function personify_pro_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'personify_pro_categories' ) ) ) {
		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,
			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'personify_pro_categories', $all_the_cool_cats );
	}

	if ( $all_the_cool_cats > 1 ) {
		// This blog has more than 1 category so personify_pro_categorized_blog should return true.
		return true;
	} else {
		// This blog has only 1 category so personify_pro_categorized_blog should return false.
		return false;
	}
}

/**
 * Flush out the transients used in personify_pro_categorized_blog.
 */
function personify_pro_category_transient_flusher() {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Like, beat it. Dig?
	delete_transient( 'personify_pro_categories' );
}
add_action( 'edit_category', 'personify_pro_category_transient_flusher' );
add_action( 'save_post',     'personify_pro_category_transient_flusher' );
