<?php
/**
 * Theme Palace widgets inclusion
 *
 * This is the template that includes all custom widgets of Theme Palace
 *
 * @package Theme Palace
 * @subpackage Theme Palace
 * @since Personify Pro 1.0
 */

/*
 * Add social link widget
 */
require get_template_directory() . '/inc/widgets/social-link-widget.php';
/*
 * Add Instagram widget
 */
require get_template_directory() . '/inc/widgets/instagram-widget.php';
/*
 * Add Latest Posts widget
 */
require get_template_directory() . '/inc/widgets/latest-posts-widget.php';
/*
 * Add popular post meta
 */
require get_template_directory() . '/inc/widgets/popular-post/popular-post-meta.php';
/*
 * Add popular post widget
 */
require get_template_directory() . '/inc/widgets/popular-post/popular-post-widget.php';


/**
 * Register widgets
 */
function personify_pro_register_widgets() {

	register_widget( 'Personify_Pro_Instagram_Widget' );

    register_widget( 'Personify_Pro_Popular_Post' );

	register_widget( 'Personify_Pro_Social_Link' );

	register_widget( 'Personify_Pro_Latest_Post' );

}
add_action( 'widgets_init', 'personify_pro_register_widgets' );