<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

get_header();

/**
 * personify_pro_simple_breadcrumb_action hook
 *
 * @hooked personify_pro_add_breadcrumb -  10
 *
 */
do_action( 'personify_pro_simple_breadcrumb_action' ); 
?>

<div id="page-title" class="relative">
    <div class="wrapper">
        <header class="page-header">
            <?php
            $options = personify_pro_get_theme_options();
        	$blog_page = ! empty( $options['blog_title'] ) ? $options['blog_title'] : esc_html__( 'Blogs', 'personify-pro' );
        	$blog_page = ( is_home() && ! is_front_page() ) ? single_post_title( '', false ) : $blog_page;
            if ( false === $options['title_break'] ) : ?>
				<h2 class="entry-title"><?php echo esc_html( $blog_page ); ?></h2>
			<?php else :
				$title = explode( ' ', $blog_page );
				$first_word = $title[0];
				$title = implode( ' ', array_slice( $title, 1 ) );
				?>
				<h2 class="entry-title"><span><?php echo esc_html( $first_word ); ?></span> <?php echo esc_html( $title ); ?></h2>
			<?php endif; ?>
        </header>
    </div><!-- .wrapper -->
</div><!-- #page-title -->

<div class="wrapper page-section no-padding-top">       
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<div class="blog-posts-wrapper">
				<?php
				if ( have_posts() ) : 
					$i = 1;
					$int = 0;
					$sticky = get_option( 'sticky_posts' );
					$paged = get_query_var( 'paged', 0 );

					/* Start the Loop */
					while ( have_posts() ) : the_post();
						if ( has_post_thumbnail() ) $int = 0;
						if ( $i <= 1 && $paged == 0 ) :
							$i = ( is_sticky() ) ? 0 : $i;
						endif;
						/**
						* Hook - personify_pro_get_content_action.
						*
						* @hooked personify_pro_get_content 
						*/
						do_action( 'personify_pro_get_content_action', $i, $int );

						$i++;
						$int++;
					endwhile;

				else :

					get_template_part( 'template-parts/content', 'none' );

				endif; 
				?>
			</div><!-- .blog-posts-wrapper -->
			<?php
			/**
			* Hook - personify_pro_action_pagination.
			*
			* @hooked personify_pro_pagination 
			*/
			do_action( 'personify_pro_action_pagination' ); 

			/**
			* Hook - personify_pro_infinite_loader_spinner_action.
			*
			* @hooked personify_pro_infinite_loader_spinner 
			*/
			do_action( 'personify_pro_infinite_loader_spinner_action' );
			?>
		</main><!-- #main -->
	</div><!-- #primary -->
</div><!-- .wrapper -->
<?php
get_footer();
