<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

get_header(); 
$options = personify_pro_get_theme_options();

if ( true === apply_filters( 'personify_pro_filter_frontpage_content_enable', true ) ) : 
	
	/**
	 * personify_pro_simple_breadcrumb_action hook
	 *
	 * @hooked personify_pro_add_breadcrumb -  10
	 *
	 */
	do_action( 'personify_pro_simple_breadcrumb_action' ); 
	?>

	<div id="page-title" class="relative">
	    <div class="wrapper">
	        <header class="page-header">
	        
				<?php
				if ( false === $options['title_break'] ) :
					the_title( '<h1 class="entry-title">', '</h1>' );
				else :
					$title = explode( ' ', get_the_title() );
					$first_word = $title[0];
					$title = implode( ' ', array_slice( $title, 1 ) );
					?>
					<h2 class="entry-title"><span><?php echo esc_html( $first_word ); ?></span> <?php echo esc_html( $title ); ?></h2>
				<?php endif; ?>

			</header><!-- .entry-header -->
	    </div><!-- .wrapper -->
	</div><!-- #page-title -->
	<div class="wrapper page-section no-padding-top">
		<div id="primary" class="content-area">
			<main id="main" class="site-main" role="main">

				<?php
				while ( have_posts() ) : the_post();

					get_template_part( 'template-parts/content', 'page' );

					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;

				endwhile; // End of the loop.
				?>

			</main><!-- #main -->
		</div><!-- #primary -->
	</div><!-- .wrapper -->
<?php
endif;
get_footer();
