<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

get_header(); 
$options = personify_pro_get_theme_options();

/**
 * personify_pro_simple_breadcrumb_action hook
 *
 * @hooked personify_pro_add_breadcrumb -  10
 *
 */
do_action( 'personify_pro_simple_breadcrumb_action' );
?>

<div id="page-title" class="relative">
    <div class="wrapper">
        <header class="page-header">
        
			<?php
			if ( false === $options['title_break'] ) :
				the_title( '<h1 class="entry-title">', '</h1>' );
			else :
				$title = explode( ' ', get_the_title() );
				$first_word = $title[0];
				$title = implode( ' ', array_slice( $title, 1 ) );
				?>
				<h2 class="entry-title"><span><?php echo esc_html( $first_word ); ?></span> <?php echo esc_html( $title ); ?></h2>
			<?php endif; 

			if ( 'post' === get_post_type() ) : ?>
				<div class="entry-meta">
					<?php personify_pro_posted_on(); ?>
				</div><!-- .entry-meta -->
			<?php endif; ?>
		</header><!-- .entry-header -->
    </div><!-- .wrapper -->
</div><!-- #page-title -->

<div class="wrapper page-section">
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<?php
			while ( have_posts() ) : the_post();

				get_template_part( 'template-parts/content', 'single' );

				/**
				* Hook personify_pro_author_profile_action
				*  
				* @hooked personify_pro_get_author_profile 
				*/
				do_action( 'personify_pro_author_profile_action' );

				/**
				* Hook personify_pro_action_post_pagination
				*  
				* @hooked personify_pro_post_pagination 
				*/
				do_action( 'personify_pro_action_post_pagination' );

				/**
				* Hook personify_pro_related_posts_action
				*  
				* @hooked personify_pro_related_posts 
				*/
				do_action( 'personify_pro_related_posts_action', get_the_id() );


				// If comments are open or we have at least one comment, load up the comment template.
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif;

			endwhile; // End of the loop.
			?>
		</main><!-- #main -->
	</div><!-- #primary -->
</div><!-- .wrapper -->

<?php
get_footer();
