<?php
/**
 * Template part for displaying page content in page.php.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

?>

<div class="single-post-wrapper">
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php if ( has_post_thumbnail() ) : ?>
			<div class="featured-image">
	            <?php the_post_thumbnail( 'full', array( 'alt' => the_title_attribute( 'echo=0' ) ) ) ?>
	        </div><!-- .featured-image -->
		<?php endif; ?>

		<div class="entry-container">
		
			<?php
				/**
				 * personify_pro_single_social_share_action hook
				 *
				 * @hooked personify_pro_social_share -  10
				 *
				 */
				do_action( 'personify_pro_single_social_share_action' );
			?>

			<div class="separator"></div>
			<div class="entry-content">
				<?php
					the_content( sprintf(
						/* translators: %s: Name of current post. */
						wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'personify-pro' ), array( 'span' => array( 'class' => array() ) ) ),
						the_title( '<span class="screen-reader-text">"', '"</span>', false )
					) );

					wp_link_pages( array(
						'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'personify-pro' ),
						'after'  => '</div>',
					) );
				?>
			</div><!-- .entry-content -->
			
			<footer class="entry-footer">
				<?php personify_pro_entry_footer(); ?>
			</footer><!-- .entry-footer -->

		</div><!-- .entry-container -->
	</article><!-- #post-## -->
</div><!-- .single-post-wrapper -->