<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

$options = personify_pro_get_theme_options();
?>

<div class="single-post-wrapper">
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php if ( has_post_thumbnail() ) : ?>
			<div class="featured-image">
	            <?php the_post_thumbnail( 'full', array( 'alt' => the_title_attribute( 'echo=0' ) ) ) ?>
	        </div><!-- .featured-image -->
		<?php endif; ?>

		<div class="entry-meta author-comments">
			<?php if ( true === $options['single_post_show_author'] ) : ?>
		        <span class="byline"> 
		            <span class="author vcard">
		                <?php personify_pro_author(); ?>
		            </span><!-- .author -->
		        </span><!-- .byline -->
		    <?php endif; 

		    if ( true === $options['single_post_show_comments'] ) : ?>
		       <span class="comments-link">
				    <?php
						/* translators: %s: post title */
						comments_popup_link( sprintf( wp_kses( __( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'personify-pro' ), array( 'span' => array( 'class' => array() ) ) ), get_the_title() ) );
					?>
				</span>
		    <?php endif; ?>
	    </div><!-- .entry-meta -->

	    <div class="entry-container">
		    <?php
				/**
				 * personify_pro_single_social_share_action hook
				 *
				 * @hooked personify_pro_social_share -  10
				 *
				 */
				do_action( 'personify_pro_single_social_share_action' );
			?>

			<div class="separator"></div>
			<div class="entry-content">
				<?php
					the_content( sprintf(
						/* translators: %s: Name of current post. */
						wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'personify-pro' ), array( 'span' => array( 'class' => array() ) ) ),
						the_title( '<span class="screen-reader-text">"', '"</span>', false )
					) );

					wp_link_pages( array(
						'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'personify-pro' ),
						'after'  => '</div>',
					) );
				?>
			</div><!-- .entry-content -->
			
			<footer class="entry-footer">
				<?php personify_pro_entry_footer(); ?>
			</footer><!-- .entry-footer -->

			<?php personify_pro_edit_link(); ?>
			
		</div><!-- .entry-container -->

	</article><!-- #post-## -->
</div><!-- .single-post-wrapper -->
