<?php
/**
 * Template part for displaying single posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Bizroot
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <?php
	  /**
	   * Hook - bizroot_single_image.
	   *
	   * @hooked bizroot_add_image_in_single_display -  10
	   */
	  do_action( 'bizroot_single_image' );
	?>

	<div class="entry-content-wrapper">
		<div class="entry-content">
			<?php the_content(); ?>
			<?php
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'bizroot-pro' ),
					'after'  => '</div>',
				) );
			?>
		</div><!-- .entry-content -->
	</div><!-- .entry-content-wrapper -->

	<footer class="entry-footer">
		<?php bizroot_entry_footer(); ?>
	</footer><!-- .entry-footer -->

</article><!-- #post-## -->

<?php
/**
 * Hook - bizroot_author_bio.
 *
 * @hooked bizroot_add_author_bio_in_single -  10
 */
do_action( 'bizroot_author_bio' );
