<?php
/**
 * Font Family Options.
 *
 * @package Nature_Bliss
 */

$font_fields = array();

// Fetch font family keys.
$font_keys = nature_bliss_get_font_family_theme_settings_options();

if ( empty( $font_keys ) ) {
	return;
}

// Font Family Section.
$wp_customize->add_section( 'section_font_family',
	array(
		'title'      => esc_html__( 'Font Family Options', 'nature-bliss-pro' ),
		'priority'   => 100,
		'capability' => 'edit_theme_options',
		'panel'      => 'theme_option_panel',
	)
);

$load_font_cdn_desc = sprintf(
	wp_kses(
		__( 'A German court fined a website using Google-hosted webfonts for violating Europe’s General Data Protection Regulation (GDPR). So this has been discouraged. More info %1$shere%2$s', 'nature-bliss-pro' ),
		array(
			'a' => array(
				'href' => array(),
				'target' => array(),
			)
		)
	),
	'<a target="_blank" href="https://make.wordpress.org/themes/2022/06/18/complying-with-gdpr-when-using-google-fonts/">',
	'</a>'
);

// Setting - reset_font_settings.
$wp_customize->add_setting( 'theme_options[load_font_cdn]',
	array(
		'default'           => $default['load_font_cdn'],
		'capability'        => 'edit_theme_options',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'nature_bliss_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[load_font_cdn]',
	array(
		'label'       => esc_html__( 'Load Google Font from CDN', 'nature-bliss-pro' ),
		'description' => $load_font_cdn_desc,
		'section'     => 'section_font_family',
		'type'        => 'checkbox',
		'priority'    => 10,
	)
);

foreach ( $font_keys as $key => $font ) {

	$wp_customize->add_setting( "theme_options[$key]",
		array(
			'default'           => esc_attr( $font['default'] ),
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'nature_bliss_sanitize_select',
		)
	);
	$wp_customize->add_control( "theme_options[$key]",
		array(
			'label'    => esc_html( $font['label'] ),
			'section'  => 'section_font_family',
			'type'     => 'select',
			'choices'  => nature_bliss_get_customizer_font_options(),
			'priority' => 100,
		)
	);

}

// Setting - reset_font_settings.
$wp_customize->add_setting( 'theme_options[reset_font_settings]',
	array(
		'default'           => $default['reset_font_settings'],
		'capability'        => 'edit_theme_options',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'nature_bliss_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[reset_font_settings]',
	array(
		'label'       => esc_html__( 'Reset Font Settings', 'nature-bliss-pro' ),
		'description' => esc_html__( 'Refresh the page after save to view full effects.', 'nature-bliss-pro' ),
		'section'     => 'section_font_family',
		'type'        => 'checkbox',
		'priority'    => 110,
	)
);
