<?php
/**
 * Recommended plugins.
 *
 * @package Nature_Bliss
 */

add_action( 'tgmpa_register', 'nature_bliss_recommended_plugins' );

if ( ! function_exists( 'nature_bliss_recommended_plugins' ) ) :
	/**
	 * Register recommended plugins.
	 *
	 * @since 1.1
	 */
	function nature_bliss_recommended_plugins() {
		/*
		 * Array of plugin arrays. Required keys are name and slug.
		 * If the source is NOT from the .org repo, then source is also required.
		 */
		$plugins = array(

			array(
				'name'      => esc_html__( 'Catch Themes Demo Import', 'nature-bliss-pro' ),
				'slug'      => 'catch-themes-demo-import',
				'required'  => false,
			),

			array(
				'name'      => esc_html__( 'Team View', 'nature-bliss-pro' ),
				'slug'      => 'team-view',
				'required'  => false,
			),

			array(
				'name'      => esc_html__( 'Contact Form 7', 'nature-bliss-pro' ),
				'slug'      => 'contact-form-7',
				'required'  => false,
			),

		);

		/*
		 * Array of configuration settings. Amend each line as needed.
		 *
		 * TGMPA will start providing localized text strings soon. If you already have translations of our standard
		 * strings available, please help us make TGMPA even better by giving us access to these translations or by
		 * sending in a pull-request with .po file(s) with the translations.
		 *
		 * Only uncomment the strings in the config array if you want to customize the strings.
		 */
		$config = array(
			'id'           => 'nature-bliss-pro',                 // Unique ID for hashing notices for multiple instances of TGMPA.
			'default_path' => '',                      // Default absolute path to bundled plugins.
			'menu'         => 'tgmpa-install-plugins', // Menu slug.
			'has_notices'  => true,                    // Show admin notices or not.
			'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
			'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
			'is_automatic' => false,                   // Automatically activate plugins after installation or not.
			'message'      => '',                      // Message to output right before the plugins table.
		);

		tgmpa( $plugins, $config );
	}

endif;
