<?php
/**
 * Class for Demo Import
 *
 * @package Nature_Bliss
 */

/**
 * Demo Import class.
 *
 * @since 1.1
 */
class Nature_Bliss_Demo_Import {

	function __construct() {
		add_filter( 'cp-ctdi/import_files', array( $this, 'import_files' ) );
		add_action( 'cp-ctdi/after_import', array( $this, 'after_import_setup' ) );
		add_filter( 'ocdi/import_files', array( $this, 'import_files' ) );
		add_action( 'ocdi/after_import', array( $this, 'after_import_setup' ) );
	}
	function import_files() {
		return array(
			array(
				'import_file_name'           => esc_html__( 'Nature Bliss Pro Demo', 'nature-bliss-pro' ),
				'import_file_url'            => get_template_directory_uri() . '/inc/support/ctdi/nature-bliss-pro.xml',
				'import_widget_file_url'     => get_template_directory_uri() . '/inc/support/ctdi/nature-bliss-pro.wie',
				'import_customizer_file_url' => get_template_directory_uri() . '/inc/support/ctdi/nature-bliss-pro.dat',
				'import_preview_image_url'   => get_template_directory_uri() . '/screenshot.png',
				'preview_url'                => 'https://wenthemes.com/item/wordpress-themes/nature-bliss-pro/',
			),
		);
	}

	function after_import_setup() {
		// Assign menus to their locations.
		$primary_menu   = get_term_by( 'name', 'Primary Menu', 'nav_menu' );
		$footer_menu    = get_term_by( 'name', 'Footer Menu', 'nav_menu' );
		$social_menu 	= get_term_by( 'name', 'Social Menu', 'nav_menu' );
		set_theme_mod(
			'nav_menu_locations',
			array(
				'primary' 	=> $primary_menu->term_id,
				'footer' 	=> $footer_menu->term_id,
				'social'  	=> $social_menu->term_id,
			)
		);
		// Assign front page and posts page (blog page).
		$front_page_id = get_page_by_title( 'Home' );
		$blog_page_id  = get_page_by_title( 'Blog' );
		update_option( 'show_on_front', 'page' );
		update_option( 'page_on_front', $front_page_id->ID );
		update_option( 'page_for_posts', $blog_page_id->ID );
	}
}

// Initialize.
$nature_bliss_ctdi = new Nature_Bliss_Demo_Import();
