<?php
/**
 * Easy Digital Downloads Theme Updater
 *
 * @package Nature_Bliss
 */

// Includes the files needed for the theme updater
if ( ! class_exists( 'EDD_Theme_Updater_Admin' ) ) {
	include dirname( __FILE__ ) . '/theme-updater-admin.php';
}

$theme = wp_get_theme( get_template() );

// Loads the updater classes
$updater = new EDD_Theme_Updater_Admin(
	// Config settings
	array(
		'remote_api_url' => 'http://themepalace.com', // Site where EDD is hosted
		'item_name'      => $theme->get( 'Name' ), // Name of theme
		'theme_slug'     => $theme->get( 'TextDomain' ), // Theme slug
		'version'        => $theme->get( 'Version' ), // The current version of this theme
		'author'         => 'WEN Themes', // The author of this theme
		'download_id'    => '0', // Optional, used for generating a license renewal link
		'renew_url'      => 'https://themepalace.com/my-account/', // Optional, allows for a custom license renewal link
		'beta'           => false, // Optional, set to true to opt into beta versions
		'item_id'        => '43109',  // The ID of the download on the storefront site
	),
	// Strings
	array(
		'theme-license'             => __( 'Theme License', 'nature-bliss-pro' ),
		'enter-key'                 => __( 'Enter your theme license key.', 'nature-bliss-pro' ),
		'license-key'               => __( 'License Key', 'nature-bliss-pro' ),
		'license-action'            => __( 'License Action', 'nature-bliss-pro' ),
		'deactivate-license'        => __( 'Deactivate License', 'nature-bliss-pro' ),
		'activate-license'          => __( 'Activate License', 'nature-bliss-pro' ),
		'status-unknown'            => __( 'License status is unknown.', 'nature-bliss-pro' ),
		'renew'                     => __( 'Renew?', 'nature-bliss-pro' ),
		'unlimited'                 => __( 'unlimited', 'nature-bliss-pro' ),
		'license-key-is-active'     => __( 'License key is active.', 'nature-bliss-pro' ),
		/* translators: the license expiration date */
		'expires%s'                 => __( 'Expires %s.', 'nature-bliss-pro' ),
		'expires-never'             => __( 'Lifetime License.', 'nature-bliss-pro' ),
		/* translators: 1. the number of sites activated 2. the total number of activations allowed. */
		'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'nature-bliss-pro' ),
		'activation-limit'          => __( 'Your license key has reached its activation limit.', 'nature-bliss-pro' ),
		/* translators: the license expiration date */
		'license-key-expired-%s'    => __( 'License key expired %s.', 'nature-bliss-pro' ),
		'license-key-expired'       => __( 'License key has expired.', 'nature-bliss-pro' ),
		/* translators: the license expiration date */
		'license-expired-on'        => __( 'Your license key expired on %s.', 'nature-bliss-pro' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'nature-bliss-pro' ),
		'license-is-inactive'       => __( 'License is inactive.', 'nature-bliss-pro' ),
		'license-key-is-disabled'   => __( 'License key is disabled.', 'nature-bliss-pro' ),
		'license-key-invalid'       => __( 'Invalid license.', 'nature-bliss-pro' ),
		'site-is-inactive'          => __( 'Site is inactive.', 'nature-bliss-pro' ),
		/* translators: the theme name */
		'item-mismatch'             => __( 'This appears to be an invalid license key for %s.', 'nature-bliss-pro' ),
		'license-status-unknown'    => __( 'License status is unknown.', 'nature-bliss-pro' ),
		'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'nature-bliss-pro' ),
		'error-generic'             => __( 'An error occurred, please try again.', 'nature-bliss-pro' ),
	)
);
