<?php
	/**
	 * The header for our theme.
	 *
	 * This is the template that displays all of the <head> section and everything up until <div id="content">
	 *
	 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
	 *
	 * @package Theme Palace
	 * @subpackage Teach Kiddo Pro
	 * @since Teach Kiddo Pro 1.0.0
	 */

	/**
	 * teach_kiddo_pro_doctype hook
	 *
	 * @hooked teach_kiddo_pro_doctype -  10
	 *
	 */
	do_action( 'teach_kiddo_pro_doctype' );

?>
<head>
<?php
	/**
	 * teach_kiddo_pro_before_wp_head hook
	 *
	 * @hooked teach_kiddo_pro_head -  10
	 *
	 */
	do_action( 'teach_kiddo_pro_before_wp_head' );

	wp_head(); 
?>
</head>

<body <?php body_class(); ?>>

<?php do_action( 'wp_body_open' ); ?>

<?php
	/**
	 * teach_kiddo_pro_page_start_action hook
	 *
	 * @hooked teach_kiddo_pro_page_start -  10
	 *
	 */
	do_action( 'teach_kiddo_pro_page_start_action' ); 

	/**
	 * teach_kiddo_pro_loader_action hook
	 *
	 * @hooked teach_kiddo_pro_loader -  10
	 *
	 */
	do_action( 'teach_kiddo_pro_before_header' );

	/**
	 * teach_kiddo_pro_header_action hook
	 *
	 * @hooked teach_kiddo_pro_header_start -  10
	 * @hooked teach_kiddo_pro_site_branding -  20
	 * @hooked teach_kiddo_pro_site_navigation -  30
	 * @hooked teach_kiddo_pro_header_end -  50
	 *
	 */
	do_action( 'teach_kiddo_pro_header_action' );

	/**
	 * teach_kiddo_pro_content_start_action hook
	 *
	 * @hooked teach_kiddo_pro_content_start -  10
	 *
	 */
	do_action( 'teach_kiddo_pro_content_start_action' );

	/**
	 * teach_kiddo_pro_header_image_action hook
	 *
	 * @hooked teach_kiddo_pro_header_image -  10
	 *
	 */
	do_action( 'teach_kiddo_pro_header_image_action' );

	if ( teach_kiddo_pro_is_frontpage() ) {
    	$options = teach_kiddo_pro_get_theme_options();
    	$sorted = array();
		$sorted = explode( ',' , teach_kiddo_pro_get_homepage_sections() );
		
		foreach ( $sorted as $section ) {
			add_action( 'teach_kiddo_pro_primary_content', 'teach_kiddo_pro_add_'. $section .'_section' );
		}

		do_action( 'teach_kiddo_pro_primary_content' );
	}