<?php
/**
 * Teach Kiddo Pro: Color Patterns
 *
 * @package WordPress
 * @subpackage Teach Kiddo Pro
 * @since 1.0
 */

/**
 * Generate the CSS for the current custom color scheme.
 */
function teach_kiddo_pro_custom_colors_css() {
  	$options= teach_kiddo_pro_get_theme_options();

	$color_value = $options['colorscheme_hue'];
	
	$css = '
	.backtotop,
	button,
	input[type="button"],
	input[type="reset"],
	input[type="submit"],
	.main-navigation ul.nav-menu > li.current-menu-item > a:before,
	.main-navigation ul ul a:hover,
	.main-navigation ul ul a:focus,
	.main-navigation .count,
	.main-navigation .search-form .search-submit:hover,
	.main-navigation .search-form .search-submit:focus,
	.menu-toggle:hover,
	.menu-toggle:focus,
	.pagination .page-numbers.current,
	.pagination .page-numbers:hover,
	.pagination .page-numbers:focus,
	.author-name:after,
	.reply a,
	.btn:hover,
	.btn:focus,
	.slick-dots li.slick-active button,
	.woocommerce ul.products li.product .onsale,
	.woocommerce span.onsale,
	.woocommerce #respond input#submit:hover, 
	.woocommerce a.button:hover, 
	.woocommerce button.button:hover, 
	.woocommerce input.button:hover,
	.woocommerce #respond input#submit:focus, 
	.woocommerce a.button:focus, 
	.woocommerce button.button:focus, 
	.woocommerce input.button:focus,
	#gallery-section .entry-header,
	.single-wrapper .entry-meta > span.tags-links a:hover,
	.single-wrapper .entry-meta > span.tags-links a:focus,
	#products-collection .btn:hover,
	#products-collection .btn:focus,
	#featured-products .btn:hover,
	#featured-products .btn:focus,
	span.discount-offer,
	.dark-version .pagination .page-numbers.current, 
	.dark-version .pagination .page-numbers:hover, 
	.dark-version .pagination .page-numbers:focus {
	    background-color: ' . esc_attr($color_value) . ';
	}

	a,
	.site-title a:hover,
	.site-title a:focus,
	.main-navigation ul.nav-menu li.current-menu-item > a,
	.main-navigation ul.nav-menu li:hover > a,
	.main-navigation ul.nav-menu li:focus > a,
	.main-navigation a:hover,
	.main-navigation a:focus,
	.main-navigation ul.nav-menu > li > a:hover,
	.main-navigation ul.nav-menu > li > a:focus,
	.post-navigation a, 
	.posts-navigation a,
	.navigation.post-navigation a:hover,
	.navigation.posts-navigation a:hover,
	.navigation.post-navigation a:focus,
	.navigation.posts-navigation a:focus,
	#secondary .cat-links a,
	#secondary ul li a:hover,
	#secondary ul li a:focus,
	.page-header small,
	.posted-on a:hover,
	.posted-on a:focus,
	#secondary .posted-on a:hover,
	#secondary .posted-on a:focus,
	.single-wrapper span.tags-links a:hover,
	.single-wrapper span.tags-links a:focus,
	.comment-metadata a:hover,
	.comment-metadata a:focus,
	.comment-meta .url:hover,
	.comment-meta .url:focus,
	.section-title a:hover,
	.section-title a:focus,
	.entry-title a:hover,
	.entry-title a:focus,
	.btn,
	.product_meta a:hover,
	.product_meta a:focus,
	.woocommerce div.product p.price, 
	.woocommerce div.product span.price,
	.woocommerce ul.products li.product .price,
	.woocommerce #respond input#submit, 
	.woocommerce a.button, 
	.woocommerce button.button, 
	.woocommerce input.button,
	#featured-courses .posted-on a:hover,
	#featured-courses .posted-on a:focus,
	#featured-courses small,
	ul.post-categories li a:hover,
	ul.post-categories li a:focus,
	.product_meta a:hover,
	.product_meta a:focus,
	.woocommerce div.product p.price, 
	.woocommerce div.product span.price,
	.woocommerce ul.products li.product .price,
	#trending-products .entry-title a:hover,
	#trending-products .entry-title a:focus,
	#trending-products .price,
	#colophon a:hover,
	#colophon a:focus,
	.dark-version #featured-courses .entry-title a:hover,
	.dark-version #featured-courses .entry-title a:focus,
	.dark-version #featured-courses .read-more a,
	.dark-version #team-section .read-more a,
	.dark-version #latest-posts .archive-blog-wrapper + .read-more a {
		color: ' . esc_attr($color_value) . ';
	}

	.loader-container svg,
	.main-navigation ul.nav-menu li:hover > svg,
	.main-navigation ul.nav-menu li:focus > svg,
	.main-navigation li.menu-item-has-children:hover > a > svg,
	.main-navigation li.menu-item-has-children > a:hover > svg,
	.main-navigation li.menu-item-has-children > a:focus > svg,
	.main-navigation ul.nav-menu > li.current-menu-item > a > svg,
	.main-navigation ul.nav-menu > li.current-menu-item > a svg,
	.main-navigation ul.nav-menu > li > a.search:hover svg.icon-search,
	.main-navigation ul.nav-menu > li > a.search:focus svg.icon-search,
	.main-navigation li.search-menu a:hover svg,
	.main-navigation li.search-menu a:focus svg,
	.main-navigation li.search-menu a.search-active svg,
	.navigation.post-navigation a:hover svg,
	.navigation.posts-navigation a:hover svg,
	.navigation.post-navigation a:focus svg,
	.navigation.posts-navigation a:focus svg,
	.widget_search form.search-form button.search-submit:hover svg,
	.widget_search form.search-form button.search-submit:focus svg,
	.single-wrapper span.posted-on svg,
	.single-wrapper span.cat-links svg {
		fill: ' . esc_attr($color_value) . ';
	}

	button,
	input[type="button"],
	input[type="reset"],
	input[type="submit"],
	.main-navigation ul.nav-menu > li.current-menu-item > a:before,
	.pagination .page-numbers.current,
	.pagination .page-numbers:hover,
	.pagination .page-numbers:focus,
	.single-wrapper span.tags-links a:hover,
	.single-wrapper span.tags-links a:focus,
	.reply a,
	.btn,
	.btn:hover,
	.btn:focus,
	.slick-dots li button,
	.woocommerce #respond input#submit, 
	.woocommerce a.button, 
	.woocommerce button.button, 
	.woocommerce input.button,
	.woocommerce #respond input#submit:hover, 
	.woocommerce a.button:hover, 
	.woocommerce button.button:hover, 
	.woocommerce input.button:hover,
	.woocommerce #respond input#submit:focus, 
	.woocommerce a.button:focus, 
	.woocommerce button.button:focus, 
	.woocommerce input.button:focus,
	.single-wrapper .entry-meta > span.tags-links a:hover,
	.single-wrapper .entry-meta > span.tags-links a:focus,
	#products-collection .btn:hover,
	#products-collection .btn:focus,
	#featured-products .btn:hover,
	#featured-products .btn:focus,
	.dark-version .pagination .page-numbers.current, 
	.dark-version .pagination .page-numbers:hover, 
	.dark-version .pagination .page-numbers:focus {
		border-color: ' . esc_attr($color_value) . ';
	}

	@media screen and (min-width: 1024px) {
		.main-navigation ul.nav-menu > li.current-menu-item > a,
		.main-navigation ul.nav-menu > li:hover > a,
		.main-navigation ul.nav-menu > li:focus > a {
			color: ' . esc_attr($color_value) . ';
		}
	}

	@keyframes preloader {
	    0% {height:5px;transform:translateY(0px);background: ' . esc_attr($color_value) . ';}
	    25% {height:30px;transform:translateY(15px);background: ' . esc_attr($color_value) . ';}
	    50% {height:5px;transform:translateY(0px);background: ' . esc_attr($color_value) . ';}
	    100% {height:5px;transform:translateY(0px);background: ' . esc_attr($color_value) . ';}
	}

	}';

	/**
	 * Filters Teach Kiddo Pro custom colors CSS.
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 *
	 * @param string $css        Base theme colors CSS.
	 */
	return apply_filters( 'teach_kiddo_pro_custom_colors_css', $css );
}
