<?php


function teach_kiddo_pro_style( $args = array() ) {
		$options = teach_kiddo_pro_get_theme_options();
	?>

		<style type="text/css">
			<?php if ( !empty($options['theme_head_typography']) ): ?>
				h1, h2, h3, h4, h5, h6 {

				    font-family: '<?php echo esc_attr( str_replace("+", " ",  $options['theme_head_typography'])) ?>', sans-serif;
				}
			<?php endif ?>
			<?php if ( !empty($options['theme_body_typography']) ): ?>
				body {

				    font-family: '<?php echo esc_attr( str_replace("+", " ",  $options['theme_body_typography'])) ?>', sans-serif;
				}
			<?php endif ?>
			<?php if ( !empty($options['theme_site_title_typography']) ): ?>
				.site-title a {
				    font-family: '<?php echo esc_attr( str_replace("+", " ",  $options['theme_site_title_typography'])) ?>', sans-serif;
				}
			<?php endif ?>
			<?php if ( !empty($options['theme_site_description_typography']) ): ?>
				.site-description {

				    font-family: '<?php echo esc_attr( str_replace("+", " ",  $options['theme_site_description_typography'])) ?>', sans-serif;
				}
			<?php endif ?>
			<?php if ( !empty($options['theme_menu_typography']) ): ?>
				.menu-item a {

				    font-family: '<?php echo esc_attr( str_replace("+", " ",  $options['theme_menu_typography'])) ?>', sans-serif;
				}
			<?php endif ?>
			<?php if ( !empty($options['theme_btn_label_typography']) ): ?>
				.btn,
				.more-link a
				 {

				    font-family: '<?php echo esc_attr( str_replace("+", " ",  $options['theme_btn_label_typography'])) ?>', sans-serif;
				}
			<?php endif; ?>

		</style>
		
<?php }

add_action( 'wp_head', 'teach_kiddo_pro_style' );