<?php
/**
 * Customizer active callbacks
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

if ( ! function_exists( 'teach_kiddo_pro_is_loader_enable' ) ) :
	/**
	 * Check if loader is enabled.
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function teach_kiddo_pro_is_loader_enable( $control ) {
		return $control->manager->get_setting( 'teach_kiddo_pro_theme_options[loader_enable]' )->value();
	}
endif;

if ( ! function_exists( 'teach_kiddo_pro_is_breadcrumb_enable' ) ) :
	/**
	 * Check if breadcrumb is enabled.
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function teach_kiddo_pro_is_breadcrumb_enable( $control ) {
		return $control->manager->get_setting( 'teach_kiddo_pro_theme_options[breadcrumb_enable]' )->value();
	}
endif;

if ( ! function_exists( 'teach_kiddo_pro_is_pagination_enable' ) ) :
	/**
	 * Check if pagination is enabled.
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function teach_kiddo_pro_is_pagination_enable( $control ) {
		return $control->manager->get_setting( 'teach_kiddo_pro_theme_options[pagination_enable]' )->value();
	}
endif;

if ( ! function_exists( 'teach_kiddo_pro_is_static_homepage_enable' ) ) :
	/**
	 * Check if static homepage is enabled.
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function teach_kiddo_pro_is_static_homepage_enable( $control ) {
		return ( 'page' == $control->manager->get_setting( 'show_on_front' )->value() );
	}
endif;

/**
 * Front Page Active Callbacks
 */

/*=====================topbar================*/
/**
 * Check if topbar section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_topbar_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[topbar_section_enable]' )->value() );
}

/**
 * Check if topbar section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_topbar_btn_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[topbar_btn]' )->value() );
}


/*========================slider====================*/

/**
 * Check if slider section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_slider_section_enable( $control ) {

	return $control->manager->get_setting( 'teach_kiddo_pro_theme_options[slider_section_enable]' )->value() ;
}

/**
 * Check if slider section content type is category.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_slider_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[slider_content_type]' )->value();
	return teach_kiddo_pro_is_slider_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if slider section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_slider_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[slider_content_type]' )->value();
	return teach_kiddo_pro_is_slider_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if slider section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_slider_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[slider_content_type]' )->value();
	return teach_kiddo_pro_is_slider_section_enable( $control ) && ( 'post' == $content_type );
}

/*===========================service==================*/

/**
 * Check if service section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_service_section_enable( $control ) {

	return $control->manager->get_setting( 'teach_kiddo_pro_theme_options[service_section_enable]' )->value() ;
}

/**
 * Check if service section content type is category.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_service_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[service_content_type]' )->value();
	return teach_kiddo_pro_is_service_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if service section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_service_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[service_content_type]' )->value();
	return teach_kiddo_pro_is_service_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if service section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_service_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[service_content_type]' )->value();
	return teach_kiddo_pro_is_service_section_enable( $control ) && ( 'post' == $content_type );
}

/*=======================testimonial=========================*/
/**
 * Check if testimonial section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_testimonial_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[testimonial_section_enable]' )->value() );
}

/**
 * Check if testimonial section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_testimonial_position_section_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[testimonial_content_type]' )->value();
	return teach_kiddo_pro_is_testimonial_section_enable( $control ) && ( 'page' == $content_type || 'post' == $content_type || 'category' == $content_type );
}

/**
 * Check if testimonial section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_testimonial_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[testimonial_content_type]' )->value();
	return teach_kiddo_pro_is_testimonial_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if testimonial section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_testimonial_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[testimonial_content_type]' )->value();
	return teach_kiddo_pro_is_testimonial_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if testimonial section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_testimonial_section_content_testimonial_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[testimonial_content_type]' )->value();
	return teach_kiddo_pro_is_testimonial_section_enable( $control ) && ( 'testimonial' == $content_type );
}

/**
 * Check if testimonial section content type is category.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_testimonial_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[testimonial_content_type]' )->value();
	return teach_kiddo_pro_is_testimonial_section_enable( $control ) && ( 'category' == $content_type );
}

/*=======================subscription=========================*/

function teach_kiddo_pro_is_subscription_section_enable( $control ) {
	return $control->manager->get_setting( 'teach_kiddo_pro_theme_options[subscription_section_enable]' )->value();
}

/*=======================blog=========================*/
/**
 * Check if blog section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_blog_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[blog_section_enable]' )->value() );
}

/**
 * Check if blog section content type is category.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_blog_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[blog_content_type]' )->value();
	return teach_kiddo_pro_is_blog_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if blog section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_blog_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[blog_content_type]' )->value();
	return teach_kiddo_pro_is_blog_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if blog section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_blog_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[blog_content_type]' )->value();
	return teach_kiddo_pro_is_blog_section_enable( $control ) && ( 'post' == $content_type );
}

/*=======================team====================*/
/**
 * Check if team section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_team_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[team_section_enable]' )->value() );
}

/**
 * Check if team section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_team_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[team_content_type]' )->value();
	return teach_kiddo_pro_is_team_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if team section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_team_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[team_content_type]' )->value();
	return teach_kiddo_pro_is_team_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if team section content type is category.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_team_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[team_content_type]' )->value();
	return teach_kiddo_pro_is_team_section_enable( $control ) && ( 'category' == $content_type );
}

function teach_kiddo_pro_is_team_section_content_position_social_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[team_content_type]' )->value();
	return teach_kiddo_pro_is_team_section_enable( $control ) && ( 'post' == $content_type || 'page' == $content_type || 'category' == $content_type );
}

/**
 * Check if team section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_team_section_content_team_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[team_content_type]' )->value();
	return teach_kiddo_pro_is_team_section_enable( $control ) && ( 'tp-team' == $content_type );
}

/**
 * Check if team section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_team_section_content_team_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[team_content_type]' )->value();
	return teach_kiddo_pro_is_team_section_enable( $control ) && ( 'tp-team-category' == $content_type );
}

/*==================gallery slider===================*/
/**
 * Check if gallery section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_gallery_section_enable( $control ) {

	return $control->manager->get_setting( 'teach_kiddo_pro_theme_options[gallery_section_enable]' )->value() ;
}

/**
 * Check if gallery section content type is category.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_gallery_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[gallery_content_type]' )->value();
	return teach_kiddo_pro_is_gallery_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if gallery section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_gallery_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[gallery_content_type]' )->value();
	return teach_kiddo_pro_is_gallery_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if gallery section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_gallery_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[gallery_content_type]' )->value();
	return teach_kiddo_pro_is_gallery_section_enable( $control ) && ( 'post' == $content_type );
}

/*============================featured===================*/
/**
 * Check if featured section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_featured_section_enable( $control ) {

	return $control->manager->get_setting( 'teach_kiddo_pro_theme_options[featured_section_enable]' )->value() ;
}

/**
 * Check if featured section content type is category.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_featured_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[featured_content_type]' )->value();
	return teach_kiddo_pro_is_featured_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if featured section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_featured_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[featured_content_type]' )->value();
	return teach_kiddo_pro_is_featured_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if featured section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_featured_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[featured_content_type]' )->value();
	return teach_kiddo_pro_is_featured_section_enable( $control ) && ( 'post' == $content_type );
}

/*===============client=======================*/
/**
 * Check if client section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_client_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[client_section_enable]' )->value() );
}

/**
 * Check if client section content type is category.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_client_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[client_content_type]' )->value();
	return teach_kiddo_pro_is_client_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if client section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_client_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[client_content_type]' )->value();
	return teach_kiddo_pro_is_client_section_enable( $control ) && ( 'page' == $content_type );
}

/*
 * Check if client section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
 
function teach_kiddo_pro_is_client_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[client_content_type]' )->value();
	return teach_kiddo_pro_is_client_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if client section content type is recent.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_client_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[client_content_type]' )->value();
	return teach_kiddo_pro_is_client_section_enable( $control ) && ( 'custom' == $content_type );
}

/*==================download===================*/
function teach_kiddo_pro_is_download_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[download_section_enable]' )->value() );
}

/*=======================career========================*/

/**
 * Check if career section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_career_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[career_section_enable]' )->value() );
}

/**
 * Check if career section content type is category.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_career_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[career_content_type]' )->value();
	return teach_kiddo_pro_is_career_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if career section content type is course-category.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_career_section_content_course_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[career_content_type]' )->value();
	return teach_kiddo_pro_is_career_section_enable( $control ) && ( 'course-category' == $content_type );
}

/*=================Featured Products====================*/

/**
 * Check if product section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_latest_products_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[latest_products_section_enable]' )->value() ) && class_exists( 'WooCommerce' );
}


/*=================products collection====================*/

/**
 * Check if product section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_products_collection_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[products_collection_section_enable]' )->value() ) && class_exists( 'WooCommerce' );
}

/**
 * Check if product section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_trending_products_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[trending_products_section_enable]' )->value() ) && class_exists( 'WooCommerce' );
}


/*=================Recent Products================*/

/**
 * Check if recent_products section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_recent_products_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[recent_products_section_enable]' )->value() );
}

function teach_kiddo_pro_is_recent_products_section_content_product_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[recent_products_content_type]' )->value();
	return teach_kiddo_pro_is_recent_products_section_enable( $control ) && ( 'product' == $content_type );
}

function teach_kiddo_pro_is_recent_products_section_content_product_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[recent_products_content_type]' )->value();
	return teach_kiddo_pro_is_recent_products_section_enable( $control ) && ( 'product-category' == $content_type );
}




/*=================featured Products================*/

/**
 * Check if featured_products section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_featured_products_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[featured_products_section_enable]' )->value() );
}

function teach_kiddo_pro_is_featured_products_section_content_product_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[featured_products_content_type]' )->value();
	return teach_kiddo_pro_is_featured_products_section_enable( $control ) && ( 'product' == $content_type );
}

function teach_kiddo_pro_is_featured_products_section_content_product_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[featured_products_content_type]' )->value();
	return teach_kiddo_pro_is_featured_products_section_enable( $control ) && ( 'product-category' == $content_type );
}

/*=====================CTA======================*/

function teach_kiddo_pro_is_cta_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[cta_section_enable]' )->value() );
}

/**
 * Check if cta section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_cta_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[cta_content_type]' )->value();
	return teach_kiddo_pro_is_cta_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if cta section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_cta_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[cta_content_type]' )->value();
	return teach_kiddo_pro_is_cta_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if cta section content type is custom.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_cta_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[cta_content_type]' )->value();
	return teach_kiddo_pro_is_cta_section_enable( $control ) && ( 'custom' == $content_type );
}

/*=================Latest Products================*/

/**
 * Check if popular_products section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_popular_products_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[popular_products_section_enable]' )->value() );
}

function teach_kiddo_pro_is_popular_products_section_content_product_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[popular_products_content_type]' )->value();
	return teach_kiddo_pro_is_popular_products_section_enable( $control ) && ( 'product' == $content_type );
}

function teach_kiddo_pro_is_popular_products_section_content_product_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[popular_products_content_type]' )->value();
	return teach_kiddo_pro_is_popular_products_section_enable( $control ) && ( 'product-category' == $content_type );
}

/*=========================Latest Posts==================*/

/**
 * Check if stories section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_stories_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[stories_section_enable]' )->value() );
}

/**
 * Check if stories section content type is category.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_stories_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[stories_content_type]' )->value();
	return teach_kiddo_pro_is_stories_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if stories section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_stories_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[stories_content_type]' )->value();
	return teach_kiddo_pro_is_stories_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if stories section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_stories_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[stories_content_type]' )->value();
	return teach_kiddo_pro_is_stories_section_enable( $control ) && ( 'post' == $content_type );
}

/*============================featured_posts===================*/
/**
 * Check if featured_posts section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_featured_posts_section_enable( $control ) {

	return $control->manager->get_setting( 'teach_kiddo_pro_theme_options[featured_posts_section_enable]' )->value() ;
}

/**
 * Check if featured_posts section content type is category.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_featured_posts_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[featured_posts_content_type]' )->value();
	return teach_kiddo_pro_is_featured_posts_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if featured_posts section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_featured_posts_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[featured_posts_content_type]' )->value();
	return teach_kiddo_pro_is_featured_posts_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if featured_posts section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_featured_posts_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[featured_posts_content_type]' )->value();
	return teach_kiddo_pro_is_featured_posts_section_enable( $control ) && ( 'post' == $content_type );
}

/*=========================Popular Posts==================*/

/**
 * Check if popular_posts section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_popular_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[popular_posts_section_enable]' )->value() );
}

/**
 * Check if popular_posts section content type is category.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_popular_posts_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[popular_posts_content_type]' )->value();
	return teach_kiddo_pro_is_popular_posts_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if popular_posts section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_popular_posts_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[popular_posts_content_type]' )->value();
	return teach_kiddo_pro_is_popular_posts_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if popular_posts section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_popular_posts_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[popular_posts_content_type]' )->value();
	return teach_kiddo_pro_is_popular_posts_section_enable( $control ) && ( 'post' == $content_type );
}

/*=========================advertisement Posts==================*/

/**
 * Check if advertisement section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_advertisement_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[advertisement_section_enable]' )->value() );
}

/*=========================Blog Posts==================*/

/**
 * Check if recent_posts section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_recent_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[recent_posts_section_enable]' )->value() );
}

/**
 * Check if recent_posts section content type is category.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_recent_posts_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[recent_posts_content_type]' )->value();
	return teach_kiddo_pro_is_recent_posts_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if recent_posts section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_recent_posts_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[recent_posts_content_type]' )->value();
	return teach_kiddo_pro_is_recent_posts_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if recent_posts section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_recent_posts_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[recent_posts_content_type]' )->value();
	return teach_kiddo_pro_is_recent_posts_section_enable( $control ) && ( 'post' == $content_type );
}

/*=======================Promotion========================*/
/**
 * Check if promotion section is enabled.
 *
 * @since teach_kiddo_pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_promotion_section_enable( $control ) {
	return ( $control->manager->get_setting( 'teach_kiddo_pro_theme_options[promotion_section_enable]' )->value() );
}

/**
 * Check if promotion section content type is post.
 *
 * @since teach_kiddo_pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_promotion_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[promotion_content_type]' )->value();
	return teach_kiddo_pro_is_promotion_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if promotion section content type is product.
 *
 * @since teach_kiddo_pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_promotion_section_content_product_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[promotion_content_type]' )->value();
	return teach_kiddo_pro_is_promotion_section_enable( $control ) && ( 'product' == $content_type );
}

/**
 * Check if promotion section content type is page.
 *
 * @since teach_kiddo_pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_promotion_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[promotion_content_type]' )->value();
	return teach_kiddo_pro_is_promotion_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if promotion section content type is page.
 *
 * @since teach_kiddo_pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_promotion_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[promotion_content_type]' )->value();
	return teach_kiddo_pro_is_promotion_section_enable( $control ) && ( 'custom' == $content_type );
}

/*========================medical_featured====================*/

/**
 * Check if medical_featured section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_medical_featured_section_enable( $control ) {

	return $control->manager->get_setting( 'teach_kiddo_pro_theme_options[medical_featured_section_enable]' )->value() ;
}

/**
 * Check if medical_featured section content type is category.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_medical_featured_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[medical_featured_content_type]' )->value();
	return teach_kiddo_pro_is_medical_featured_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if medical_featured section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_medical_featured_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[medical_featured_content_type]' )->value();
	return teach_kiddo_pro_is_medical_featured_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if medical_featured section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_medical_featured_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[medical_featured_content_type]' )->value();
	return teach_kiddo_pro_is_medical_featured_section_enable( $control ) && ( 'post' == $content_type );
}

/*========================popular_course====================*/

/**
 * Check if medical_featured section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_popular_course_section_enable( $control ) {

	return $control->manager->get_setting( 'teach_kiddo_pro_theme_options[popular_course_section_enable]' )->value() ;
}

/**
 * Check if popular_course section content type is category.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_popular_course_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[popular_course_content_type]' )->value();
	return teach_kiddo_pro_is_popular_course_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if popular_course section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_popular_course_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[popular_course_content_type]' )->value();
	return teach_kiddo_pro_is_popular_course_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if popular_course section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_popular_course_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[popular_course_content_type]' )->value();
	return teach_kiddo_pro_is_popular_course_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if popular_course section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_popular_course_section_content_course_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[popular_course_content_type]' )->value();
	return teach_kiddo_pro_is_popular_course_section_enable( $control ) && ( 'course' == $content_type );
}

function teach_kiddo_pro_is_popular_course_section_content_course_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[popular_course_content_type]' )->value();
	return teach_kiddo_pro_is_popular_course_section_enable( $control ) && ( 'course-category' == $content_type );
}



/*========================featured_course====================*/

/**
 * Check if medical_featured section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_featured_course_section_enable( $control ) {

	return $control->manager->get_setting( 'teach_kiddo_pro_theme_options[featured_course_section_enable]' )->value() ;
}

/**
 * Check if featured_course section content type is category.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_featured_course_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[featured_course_content_type]' )->value();
	return teach_kiddo_pro_is_featured_course_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if featured_course section content type is page.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_featured_course_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[featured_course_content_type]' )->value();
	return teach_kiddo_pro_is_featured_course_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if featured_course section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_featured_course_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[featured_course_content_type]' )->value();
	return teach_kiddo_pro_is_featured_course_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if featured_course section content type is post.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_featured_course_section_content_course_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[featured_course_content_type]' )->value();
	return teach_kiddo_pro_is_featured_course_section_enable( $control ) && ( 'course' == $content_type );
}

function teach_kiddo_pro_is_featured_course_section_content_course_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[featured_course_content_type]' )->value();
	return teach_kiddo_pro_is_featured_course_section_enable( $control ) && ( 'course-category' == $content_type );
}


/*========================Counter====================*/

/**
 * Check if counter section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_counter_section_enable( $control ) {

	return $control->manager->get_setting( 'teach_kiddo_pro_theme_options[counter_section_enable]' )->value() ;
}

/*========================contact====================*/

/**
 * Check if contact section is enabled.
 *
 * @since Teach Kiddo Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function teach_kiddo_pro_is_contact_section_enable( $control ) {

	return $control->manager->get_setting( 'teach_kiddo_pro_theme_options[contact_section_enable]' )->value() ;
}


/*====================sortable=================*/

function teach_kiddo_pro_is_all_layout( $control ) {
	$design = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[home_layout]' )->value();
	return ( 'all-design' == $design );
}

//pro layout 
function teach_kiddo_pro_is_default_layout( $control ) {
	$design = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[home_layout]' )->value();
	return ( 'default-design' == $design );
}

//second layout 
function teach_kiddo_pro_is_second_layout( $control ) {
	$design = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[home_layout]' )->value();
	return ( 'second-design' == $design );
}

//third layout 
function teach_kiddo_pro_is_third_layout( $control ) {
	$design = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[home_layout]' )->value();
	return ( 'third-design' == $design );
}

//fourth layout 
function teach_kiddo_pro_is_fourth_layout( $control ) {
	$design = $control->manager->get_setting( 'teach_kiddo_pro_theme_options[home_layout]' )->value();
	return ( 'fourth-design' == $design );
}

