<?php
/**
 * Teach Kiddo Pro Customizer.
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function teach_kiddo_pro_customize_register( $wp_customize ) {
	$options = teach_kiddo_pro_get_theme_options();

	// Load custom control functions.
	require get_template_directory() . '/inc/customizer/custom-controls.php';

	// Load customize active callback functions.
	require get_template_directory() . '/inc/customizer/active-callback.php';

	// Load partial callback functions.
	require get_template_directory() . '/inc/customizer/partial.php';

	// Load validation callback functions.
	require get_template_directory() . '/inc/customizer/validation.php';

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';


	// Remove the core header textcolor control, as it shares the main text color.
	$wp_customize->remove_control( 'header_textcolor' );

	// Header title color setting and control.
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[header_title_color]', array(
		'default'           => $options['header_title_color'],
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'			=> 'postMessage'
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'teach_kiddo_pro_theme_options[header_title_color]', array(
		'priority'			=> 5,
		'label'             => esc_html__( 'Header Title Color', 'teach-kiddo-pro' ),
		'section'           => 'colors',
	) ) );

	// Header tagline color setting and control.
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[header_tagline_color]', array(
		'default'           => $options['header_tagline_color'],
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'			=> 'postMessage'
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'teach_kiddo_pro_theme_options[header_tagline_color]', array(
		'priority'			=> 6,
		'label'             => esc_html__( 'Header Tagline Color', 'teach-kiddo-pro' ),
		'section'           => 'colors',
	) ) );

	// Site identity extra options.
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[header_txt_logo_extra]', array(
		'default'           => $options['header_txt_logo_extra'],
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
		'transport'			=> 'refresh'
	) );

	$wp_customize->add_control( 'teach_kiddo_pro_theme_options[header_txt_logo_extra]', array(
		'priority'			=> 50,
		'type'				=> 'radio',
		'label'             => esc_html__( 'Site Identity Extra Options', 'teach-kiddo-pro' ),
		'section'           => 'title_tagline',
		'choices'				=> array( 
			'hide-all'     => esc_html__( 'Hide All', 'teach-kiddo-pro' ),
			'show-all'     => esc_html__( 'Show All', 'teach-kiddo-pro' ),
			'title-only'   => esc_html__( 'Title Only', 'teach-kiddo-pro' ),
			'tagline-only' => esc_html__( 'Tagline Only', 'teach-kiddo-pro' ),
			'logo-title'   => esc_html__( 'Logo + Title', 'teach-kiddo-pro' ),
			'logo-tagline' => esc_html__( 'Logo + Tagline', 'teach-kiddo-pro' ),
			)
	) );

	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[theme_version]', array(
		'default'           => $options['theme_version'],
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
	) );

	$wp_customize->add_control( 'teach_kiddo_pro_theme_options[theme_version]', array(
		'type'    => 'radio',
		'label'    => esc_html__( 'Theme Version', 'teach-kiddo-pro' ),
		'choices'  => array(
			'lite-version'   => esc_html__( 'Lite Version', 'teach-kiddo-pro' ),
            'dark-version'      => esc_html__( 'Dark Version', 'teach-kiddo-pro' ),
		),
		'section'  => 'colors',
	) );
	/**
	 * Custom colors.
	 */
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[colorscheme]', array(
		'default'           => $options['colorscheme'],
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
	) );

	$wp_customize->add_control( 'teach_kiddo_pro_theme_options[colorscheme]', array(
		'type'    => 'radio',
		'label'    => esc_html__( 'Color Scheme', 'teach-kiddo-pro' ),
		'choices'  => array(
			'default'   => esc_html__( 'Default', 'teach-kiddo-pro' ),
            'blue'      => esc_html__( 'Blue', 'teach-kiddo-pro' ),
            'green'     => esc_html__( 'Green', 'teach-kiddo-pro' ),
            'red'       => esc_html__( 'Red', 'teach-kiddo-pro' ),
            'violet'    => esc_html__( 'Violet', 'teach-kiddo-pro' ),
            'custom'    => esc_html__( 'Custom', 'teach-kiddo-pro' ),
		),
		'section'  => 'colors',
	) );

	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[colorscheme_hue]', array(
		'default'           => $options['colorscheme_hue'],
		'sanitize_callback' => 'sanitize_hex_color', // The hue is stored as a positive integer.
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'teach_kiddo_pro_theme_options[colorscheme_hue]', array(
		'section'  => 'colors',
	) ) );

	// Add panel for common theme options
	$wp_customize->add_panel( 'teach_kiddo_pro_theme_options_panel' , array(
	    'title'      => esc_html__( 'Theme Options','teach-kiddo-pro' ),
	    'description'=> esc_html__( 'Teach Kiddo Pro Theme Options.', 'teach-kiddo-pro' ),
	    'priority'   => 150,
	) );

	// loader
	require get_template_directory() . '/inc/customizer/theme-options/loader.php';

	// breadcrumb
	require get_template_directory() . '/inc/customizer/theme-options/breadcrumb.php';

	// banner
	require get_template_directory() . '/inc/customizer/theme-options/banner.php';

	// typography
	require get_template_directory() . '/inc/customizer/theme-options/typography.php';

	// load layout
	require get_template_directory() . '/inc/customizer/theme-options/layout.php';

	// load menu
	require get_template_directory() . '/inc/customizer/theme-options/menu.php';

	// load static homepage option
	require get_template_directory() . '/inc/customizer/theme-options/homepage-static.php';

	// load archive option
	require get_template_directory() . '/inc/customizer/theme-options/excerpt.php';

	// load archive option
	require get_template_directory() . '/inc/customizer/theme-options/archive.php';
	
	// load single post option
	require get_template_directory() . '/inc/customizer/theme-options/single-posts.php';

	// load pagination option
	require get_template_directory() . '/inc/customizer/theme-options/pagination.php';

	// load footer option
	require get_template_directory() . '/inc/customizer/theme-options/footer.php';

	// load reset option
	require get_template_directory() . '/inc/customizer/theme-options/reset.php';

	// Add panel for front page theme options.
	$wp_customize->add_panel( 'teach_kiddo_pro_front_page_panel' , array(
	    'title'      => esc_html__( 'Front Page','teach-kiddo-pro' ),
	    'description'=> esc_html__( 'Front Page Theme Options.', 'teach-kiddo-pro' ),
	    'priority'   => 140,
	) );

	// Add panel for front page theme options.
	$wp_customize->add_panel( 'teach_kiddo_pro_front_page_panel' , array(
	    'title'      => esc_html__( 'Front Page','teach-kiddo-pro' ),
	    'description'=> esc_html__( 'Front Page Theme Options.', 'teach-kiddo-pro' ),
	    'priority'   => 140,
	) );

	//home-layout option
	require get_template_directory() . '/inc/customizer/sections/home-layout.php';

	// load topbar option
	require get_template_directory() . '/inc/customizer/sections/topbar.php';

	foreach ( explode( ',', $options['all_sortable'] ) as $list ) {
		require get_template_directory() . '/inc/customizer/sections/'.str_replace( '_', '-', $list).'.php';
	}

}
add_action( 'customize_register', 'teach_kiddo_pro_customize_register' );

/*
 * Load customizer sanitization functions.
 */
require get_template_directory() . '/inc/customizer/sanitize.php';

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function teach_kiddo_pro_customize_preview_js() {
	wp_enqueue_script( 'teach-kiddo-pro-customizer', get_template_directory_uri() . '/assets/js/customizer' . teach_kiddo_pro_min() . '.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'teach_kiddo_pro_customize_preview_js' );

/**
 * Load dynamic logic for the customizer controls area.
 */
function teach_kiddo_pro_customize_control_js() {
	// fontawesome
	wp_enqueue_style( 'font-awesome-css', get_template_directory_uri() . '/assets/css/font-awesome' . teach_kiddo_pro_min() . '.css' );
	
	// Choose from select jquery.
	wp_enqueue_style( 'chosen-css', get_template_directory_uri() . '/assets/css/chosen' . teach_kiddo_pro_min() . '.css' );
	wp_enqueue_script( 'jquery-chosen', get_template_directory_uri() . '/assets/js/chosen.jquery' . teach_kiddo_pro_min() . '.js', array( 'jquery' ), '1.4.2', true );

	// simple icon picker
	wp_enqueue_style( 'simple-iconpicker-css', get_template_directory_uri() . '/assets/css/simple-iconpicker' . teach_kiddo_pro_min() . '.css' );
	wp_enqueue_script( 'jquery-simple-iconpicker', get_template_directory_uri() . '/assets/js/simple-iconpicker' . teach_kiddo_pro_min() . '.js', array( 'jquery' ), '', true );

	wp_enqueue_style( 'teach-kiddo-pro-customize-controls-css', get_template_directory_uri() . '/assets/css/customize-controls' . teach_kiddo_pro_min() . '.css' );
	wp_enqueue_script( 'teach-kiddo-pro-customize-controls', get_template_directory_uri() . '/assets/js/customize-controls' . teach_kiddo_pro_min() . '.js', array(), '1.0', true );
	$teach_kiddo_pro_reset_data = array(
		'reset_message' => esc_html__( 'Refresh the customizer page after saving to view reset effects', 'teach-kiddo-pro' )
	);
	// Send list of color variables as object to custom customizer js
	wp_localize_script( 'teach-kiddo-pro-customize-controls', 'teach_kiddo_pro_reset_data', $teach_kiddo_pro_reset_data );
}
add_action( 'customize_controls_enqueue_scripts', 'teach_kiddo_pro_customize_control_js' );

if ( !function_exists( 'teach_kiddo_pro_reset_options' ) ) :
	/**
	 * Reset all options
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 *
	 * @param bool $checked Whether the reset is checked.
	 * @return bool Whether the reset is checked.
	 */
	function teach_kiddo_pro_reset_options() {
		$options = teach_kiddo_pro_get_theme_options();
		if ( true === $options['reset_options'] ) {
			// Reset custom theme options.
			set_theme_mod( 'teach_kiddo_pro_theme_options', array() );
			// Reset custom header and backgrounds.
			remove_theme_mod( 'header_image' );
			remove_theme_mod( 'header_image_data' );
			remove_theme_mod( 'background_image' );
			remove_theme_mod( 'background_color' );
			remove_theme_mod( 'header_textcolor' );
	    }
	  	else {
		    return false;
	  	}
	}
endif;
add_action( 'customize_save_after', 'teach_kiddo_pro_reset_options' );
