<?php
/**
* Customizer default options
*
* @package Theme Palace
* @subpackage Teach Kiddo Pro
* @since Teach Kiddo Pro 1.0.0
* @return array An array of default values
*/

function teach_kiddo_pro_get_default_theme_options() {
	$theme_data = wp_get_theme();
	$teach_kiddo_pro_default_options = array(
		// Color Options
		'header_title_color'			=> '#2c2d39',
		'header_tagline_color'			=> '#990f12',
		'header_txt_logo_extra'			=> 'show-all',
		'colorscheme_hue'				=> '#990f12',
		'colorscheme'					=> 'default',
		'theme_version'					=> 'lite-version',
		'home_layout'					=> 'default-design',

		// typography Options
		'theme_typography' 				=> 'default',
		'body_theme_typography' 		=> 'default',

		// loader
		'loader_enable'         		=> (bool) false,
		'loader_icon'         			=> 'default',

		// banner
		'hide_single_page_banner'		=> (bool) true,
		'hide_single_post_banner'		=> (bool) true,

		// breadcrumb
		'breadcrumb_enable'				=> (bool) true,
		'breadcrumb_separator'			=> '/',

		// layout 
		'site_layout'         			=> 'wide-layout',
		'sidebar_position'         		=> 'right-sidebar',
		'post_sidebar_position' 		=> 'right-sidebar',
		'page_sidebar_position' 		=> 'right-sidebar',
		'menu_sticky'					=> (bool) true,
		'menu_search'					=> (bool) true,

		// excerpt options
		'long_excerpt_length'           => 25,

		// pagination options
		'pagination_enable'         	=> (bool) true,
		'pagination_type'         		=> 'default',

		// footer options
		'copyright_text'           		=> sprintf( esc_html_x( 'Copyright &copy; %1$s %2$s', '1: Year, 2: Site Title with home URL', 'teach-kiddo-pro' ), '[the-year]', '[site-link]' ),
		'scroll_top_visible'        	=> (bool) true,

		// reset options
		'reset_options'      			=> (bool) false,

		// homepage options
		'enable_frontpage_content' 		=> (bool) false,

		// homepage sections sortable
		'all_sortable'	=> 'slider,service,counter,team,subscription,gallery,testimonial,blog,contact,popular_course,featured_course,promotion,client,featured_posts,recent_posts,popular_posts,stories,instagram,latest_products,popular_products,products_collection,recent_products,featured_products,trending_products',

		'default_sortable'	=> 'slider,service,counter,team,subscription,gallery,testimonial,blog,contact,popular_course,featured_course',

		'second_sortable'	=> 'slider,service,promotion,team,gallery,counter,subscription,testimonial,blog,client,contact',

		'third_sortable'	=> 'slider,latest_products,popular_products,promotion,products_collection,recent_products,featured_products,trending_products,testimonial,subscription,blog,contact',

		'fourth_sortable'	=> 'slider,featured_posts,recent_posts,promotion,popular_posts,stories,instagram,subscription,blog',

		// blog/archive options
		'your_latest_posts_title' 		=> esc_html__( 'Blogs', 'teach-kiddo-pro' ),
		'hide_date' 					=> (bool) false,
		'hide_image'					=> (bool) false,
		'hide_category'					=> (bool) false,
		'hide_author'					=> (bool) false,
		'hide_title'					=> (bool) false,
		'archive_btn_title'				=> esc_html__( 'Read More', 'teach-kiddo-pro' ),

		// single post theme options
		'single_post_hide_date' 		=> (bool) false,
		'single_post_hide_author'		=> (bool) false,
		'single_post_hide_category'		=> (bool) false,
		'single_post_hide_tags'			=> (bool) false,
		'single_post_hide_image'		=> (bool) false,
		'single_post_hide_description'	=> (bool) false,

		/* Front Page */

		// topbar
		'topbar_section_enable'			=> (bool) true,
		'topbar_btn'				=> (bool) true,
		'social_menu_enable'			=> (bool) true,
		'topbar_btn_title'				=> esc_html__( 'Apply', 'teach-kiddo-pro' ),
		'topbar_btn_url'				=> esc_html__( '#', 'teach-kiddo-pro' ),
		'topbar_field_1'				=> esc_html__( ' 123 456 7891', 'teach-kiddo-pro' ),
		'topbar_field_2'				=> esc_html__( 'info@Teach Kiddo.com', 'teach-kiddo-pro' ),

		//menu
		'menu_btn_title'				=> esc_html__( 'Get Starts', 'teach-kiddo-pro' ),
		'menu_btn_url'					=> '',

		// slider
		'slider_section_enable'			=> (bool) true,
		'slider_content_type'			=> 'post',
		'slider_autoplay'				=> (bool) false,
		'slider_count'					=> 3,
		'slider_excerpt_length'			=> 25,
		'slider_search_enable'			=> (bool)false,
		'slider_course_search_enable'   => (bool)false,
		'slider_read_more'				=> esc_html__( 'Read More', 'teach-kiddo-pro' ),
		'slider_btn_title'				=> esc_html__( 'Learn More', 'teach-kiddo-pro' ),

		//service 
		'service_section_enable'		=> (bool) true,
		'service_content_type'			=> 'post',
		'service_title'					=> esc_html__( 'Learn From People Around you', 'teach-kiddo-pro' ),
		'service_sub_title'				=> esc_html__( 'Get Started!', 'teach-kiddo-pro' ),
		'service_description'			=> esc_html__( 'While college tuition more than tripled over the past 30 years, the value of a college degree gradually fell due to credential inflation. As more people get degrees, what used to be a unique achievement becomes trivial.', 'teach-kiddo-pro' ),
		'service_btn'					=> esc_html__( 'Read More', 'teach-kiddo-pro' ),
		'service_count'					=> 4,
		'service_excerpt_length'		=> 20,

		//about 
		'about_section_enable'		=> (bool) true,
		'about_excerpt_length'		=> 30,
		'about_content_type'		=> 'post',
		'about_sub_title'			=> esc_html__( 'About Us', 'teach-kiddo-pro' ),
		'about_btn_text'			=> esc_html__( 'I Want TO Learn More', 'teach-kiddo-pro' ),
		'about_video_intro_text'	=> esc_html__( 'Watch intro video about our system:', 'teach-kiddo-pro' ),
		'about_video_sub_intro_text'			=> esc_html__( 'We are here to create a history!!', 'teach-kiddo-pro' ),

		// testimonial
		'testimonial_section_enable'					=> (bool) true,
		'testimonial_section_link_enable'				=> (bool) false,
		'testimonial_content_type'						=> 'page',
		'testimonial_count'								=> 4,
		'testimonial_excerpt_length'					=> 25,
		'testimonial_section_autoplay_slider_enable'	=> (bool) true,
		'testimonial_section_buttom_slider_enable'		=> (bool) true,
		'testimonial_sub_title'							=> esc_html__( 'Testimonials', 'teach-kiddo-pro' ),
		'testimonial_title'								=> esc_html__( 'What Happy People Said About Teach Kiddo', 'teach-kiddo-pro' ),

		//popular course 
		'popular_course_section_enable'		=> true,
		'popular_course_content_type'		=> 'page',
		'popular_course_count'				=> 4,
		'popular_course_read_more'			=> esc_html__( 'Join Course', 'teach-kiddo-pro' ),
		'popular_course_title'				=> esc_html__( 'Most Popular Courses', 'teach-kiddo-pro' ),
		'popular_course_btn_title'			=> esc_html__( 'View All Courses', 'teach-kiddo-pro' ),

		//featured course 
		'featured_course_section_enable'	=> true,
		'featured_course_content_type'		=> 'page',
		'featured_course_count'				=> 4,
		'featured_course_read_more'			=> esc_html__( 'View Course', 'teach-kiddo-pro' ),
		'featured_course_title'				=> esc_html__( 'Featured Courses', 'teach-kiddo-pro' ),
		'featured_course_excerpt_length'	=> 40,
		'featured_starts_on_label'			=> esc_html__( 'Enroll Now', 'teach-kiddo-pro' ),
		'featured_estemate_label'			=> esc_html__( 'Estimated Time', 'teach-kiddo-pro' ),
		'featured_rating_label'				=> esc_html__( 'Course Rating', 'teach-kiddo-pro' ),

		// subscription
		'subscription_section_enable'	=> (bool) true,
		'subscription_title'			=> esc_html__( 'Get 20% off in Your First Course', 'teach-kiddo-pro' ),
		'subscription_description'		=> esc_html__( 'Enter your email address...', 'teach-kiddo-pro' ),
		'subscription_btn_title'		=> esc_html__( 'Send', 'teach-kiddo-pro' ),

		// blog
		'blog_section_enable'			=> (bool) true,
		'blog_content_type'				=> 'post',
		'blog_count'					=> 4,
		'blog_excerpt_length'			=> 25,
		'blog_title'					=> esc_html__( 'Our recent articles', 'teach-kiddo-pro' ),
		'blog_sub_title'				=> esc_html__( 'Know what’s happening', 'teach-kiddo-pro' ),
		'blog_btn_title'				=> esc_html__( 'Read More', 'teach-kiddo-pro' ),
		'blog_alt_btn_title'			=> esc_html__( 'Show All Aricle', 'teach-kiddo-pro' ),

		//team 
		'team_section_enable'					=> (bool) true,
		'team_content_type'						=> 'page',
		'team_count'							=> 5,
		'team_section_autoplay_slider_enable'	=> (bool) true,
		'team_section_buttom_slider_enable'		=> (bool) true,
		'team_title'							=> esc_html__( 'Our Team Members', 'teach-kiddo-pro' ),
		'team_sub_title'						=> esc_html__( 'We Are Family', 'teach-kiddo-pro' ),	
		'team_btn_title'						=> esc_html__( 'View All Team', 'teach-kiddo-pro' ),	

		// gallery slider
		'gallery_section_enable'		=> (bool) true,
		'gallery_content_type'			=> 'post',
		'gallery_autoplay'				=> (bool) true,
		'gallery_count'					=> 4,
		'gallery_title'					=> esc_html__( 'Our Photo Gallery', 'teach-kiddo-pro' ),
		'gallery_btn_title'				=> esc_html__( 'View All Gallery', 'teach-kiddo-pro' ),
		'gallery_btn_url'				=> '',

		// client
		'client_section_enable'			=> (bool) true,
		'client_content_type'			=> 'page',
		'client_count'					=> 6,
		'client_title'					=> esc_html__( 'Many peope use Teach Kiddo to enrich their brand & business.', 'teach-kiddo-pro' ),

		// featured_products
		'featured_products_section_enable'	=> (bool) true,
		'featured_products_count'				=> 3,

		//featured products
		'featured_products_section_enable'	=> (bool) true,
		'featured_products_content_type'		=> 'product-category',
		'featured_products_count'				=> 4,
		'featured_products_btn_label'			=> esc_html__( 'Buy Now', 'teach-kiddo-pro' ),

		//recent products
		'recent_products_section_enable'	=> (bool) true,
		'recent_products_content_type'		=> 'product-category',
		'recent_products_count'			=> 4,
		'recent_products_title'			=> esc_html__( 'Popular Products', 'teach-kiddo-pro' ),
		'recent_products_sub_title'		=> esc_html__( 'Sale', 'teach-kiddo-pro' ),

		//popular products
		'popular_products_section_enable'	=> (bool) true,
		'popular_products_content_type'		=> 'product-category',
		'popular_products_count'			=> 4,
		'popular_products_title'			=> esc_html__( 'popular Products', 'teach-kiddo-pro' ),

		//latest products
		'latest_products_section_enable'	=> (bool) true,
		'latest_products_count'				=> 2,

		//products collection
		'products_collection_section_enable'	=> (bool) true,
		'products_collection_title'				=> esc_html__( 'Products Collection', 'teach-kiddo-pro' ),
		'products_collection_btn_label'			=> esc_html__( 'starts Shopphing', 'teach-kiddo-pro' ),

		//trending products
		'trending_products_section_enable'	=> (bool) true,

		//stories
		'stories_section_enable'	=> (bool) true,
		'stories_content_type'		=> 'post',
		'stories_count'				=> 3,
		'stories_excerpt_length'	=> 25,
		'stories_title'				=> esc_html__( 'OUR LATEST Blogs', 'teach-kiddo-pro' ),
		'stories_btn_label'			=> esc_html__( 'View All Blog', 'teach-kiddo-pro' ),

		//instagram
		'instagram_section_enable' => false,
		'instagram_title'			=> esc_html__( 'Instagram', 'teach-kiddo-pro' ),

		//featured_posts
		'featured_posts_section_enable'		=> (bool) true,
		'featured_posts_count'				=> 3,
		'featured_posts_content_type'			=> 'post',
		'featured_posts_col_layout'			=> 'col-3',

		//popular_posts
		'popular_posts_section_enable'	=> (bool) true,
		'popular_posts_content_type'	=> 'post',
		'popular_posts_count'			=> 3,
		'popular_posts_excerpt_length'	=> 25,
		'popular_posts_sub_title'		=> esc_html__( 'Popular Post', 'teach-kiddo-pro' ),
		'popular_posts_title'			=> esc_html__( 'What Happy People Said About Teach Kiddo', 'teach-kiddo-pro' ),
		'popular_posts_btn'				=> esc_html__( 'Learn More', 'teach-kiddo-pro' ),

		//advertisement
		'advertisement_section_enable'	=> (bool) true,

		//recent_posts
		'recent_posts_section_enable'		=> (bool) true,
		'recent_posts_content_type'		=> 'post',
		'recent_posts_count'				=> 3,
		'recent_posts_excerpt_length'		=> 25,
		'recent_posts_title'				=> esc_html__( 'Lifestyle & Fashion', 'teach-kiddo-pro'),

		//promotion
		'promotion_section_enable'		=> (bool) true,
		'promotion_excerpt_length'		=> 25,
		'promotion_content_type'		=> 'page',
		'promotion_title'				=> esc_html__( 'Providing Medical Care for the Sickest', 'teach-kiddo-pro' ),
		'promotion_description'			=> esc_html__( 'Dentistry, also known as dental medicine and ‘oral medicine, is a branch of medicine that consists of the study, diagnosis, prevention, and treatment.', 'teach-kiddo-pro' ),
		'promotion_button'				=> esc_html__( 'Get A Quote', 'teach-kiddo-pro' ),

		// counter
		'counter_section_enable'		=> (bool) true,
		'counter_count'					=> 4,
		'counter_column'				=> 'col-4',

		// contact 
		'contact_section_enable'        => (bool) true,
		'contact_title_1'				=> esc_html__( 'Contact Info', 'teach-kiddo-pro' ),
		'contact_title_2'				=> esc_html__( 'Inquiry Form', 'teach-kiddo-pro' ),

		//footer
		'footer_text'					=> esc_html__( 'Join thousands of learners making a difference every day using Teach Kiddo.', 'teach-kiddo-pro' ),
		'footer_btn_title'				=> esc_html__( 'Explore a free course', 'teach-kiddo-pro' ),

		);

$output = apply_filters( 'teach_kiddo_pro_default_theme_options', $teach_kiddo_pro_default_options );

// Sort array in ascending order, according to the key:
if ( ! empty( $output ) ) {
	ksort( $output );
}

return $output;
}


