<?php
/**
 * About Section options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add About section
$wp_customize->add_section( 'teach_kiddo_pro_about_section', array(
	'title'             => esc_html__( 'About Us','teach-kiddo-pro' ),
	'description'       => esc_html__( 'About Us Section options.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return (
            teach_kiddo_pro_is_default_layout( $control )
            ||
            teach_kiddo_pro_is_second_layout( $control )
            ||
            teach_kiddo_pro_is_fourth_layout( $control )
            ||
            teach_kiddo_pro_is_fifth_layout( $control )
        );
    },
) );

// About content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[about_section_enable]', array(
	'default'			=> 	$options['about_section_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[about_section_enable]', array(
	'label'             => esc_html__( 'About Section Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_about_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[about_section_enable]', array(
		'selector'            => '#about-us .tooltiptext',
		'settings'            => 'teach_kiddo_pro_theme_options[about_section_enable]',
    ) );
}

// about title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[about_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['about_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[about_sub_title]', array(
	'label'           	=> esc_html__( 'Sub Title', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_about_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_about_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[about_sub_title]', array(
		'selector'            => '#about-us p.section-subtitle',
		'settings'            => 'teach_kiddo_pro_theme_options[about_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_about_sub_title_partial',
    ) );
}

// about title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[about_btn_text]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['about_btn_text'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[about_btn_text]', array(
	'label'           	=> esc_html__( 'Button Label', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_about_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_about_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[about_btn_text]', array(
		'selector'            => '#about-us div.read-more a',
		'settings'            => 'teach_kiddo_pro_theme_options[about_btn_text]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_about_btn_text_partial',
    ) );
}

// long Excerpt length setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[about_excerpt_length]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
	'validate_callback' => 'teach_kiddo_pro_validate_long_excerpt',
	'default'			=> $options['about_excerpt_length'],
	) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[about_excerpt_length]', array(
	'label'       		=> esc_html__( 'About Excerpt Length', 'teach-kiddo-pro' ),
	'description' 		=> esc_html__( 'Total description words to be displayed in about posts.', 'teach-kiddo-pro' ),
	'section'     		=> 'teach_kiddo_pro_about_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_about_section_enable',
	'type'        		=> 'number',
	'input_attrs' 		=> array(
		'style'       => 'width: 80px;',
		'max'         => 100,
		'min'         => 5,
		),
	) );

// About content type control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[about_content_type]', array(
	'default'          	=> $options['about_content_type'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[about_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_about_section',
	'type'				=> 'select',
	'active_callback' 	=> 'teach_kiddo_pro_is_about_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'teach-kiddo-pro' ),
		'post' 		=> esc_html__( 'Post', 'teach-kiddo-pro' ),
	),
) );

// about pages drop down chooser control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[about_content_page]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[about_content_page]', array(
	'label'             => esc_html__( 'Select Page', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_about_section',
	'choices'			=> teach_kiddo_pro_page_choices(),
	'active_callback'	=> 'teach_kiddo_pro_is_about_section_content_page_enable',
) ) );

// about posts drop down chooser control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[about_content_post]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[about_content_post]', array(
	'label'             => esc_html__( 'Select Post', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_about_section',
	'choices'			=> teach_kiddo_pro_post_choices(),
	'active_callback'	=> 'teach_kiddo_pro_is_about_section_content_post_enable',
) ) );

// about description setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[about_video_intro_text]', array(
	'sanitize_callback' => 'teach_kiddo_pro_santize_allow_tag',
	'default'			=> $options['about_video_intro_text'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[about_video_intro_text]', array(
	'label'           	=> esc_html__( 'Video Intro Text', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_about_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_about_section_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[about_video_intro_text]', array(
		'selector'            => '#about-us h2.entry-title',
		'settings'            => 'teach_kiddo_pro_theme_options[about_video_intro_text]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_about_video_intro_text_partial',
    ) );
}

// about description setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[about_video_sub_intro_text]', array(
	'sanitize_callback' => 'teach_kiddo_pro_santize_allow_tag',
	'default'			=> $options['about_video_sub_intro_text'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[about_video_sub_intro_text]', array(
	'label'           	=> esc_html__( 'Video Intro Sub Text', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_about_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_about_section_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[about_video_sub_intro_text]', array(
		'selector'            => '#about-us .entry-header p',
		'settings'            => 'teach_kiddo_pro_theme_options[about_video_sub_intro_text]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_about_video_sub_intro_text_partial',
    ) );
}

// about image setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[about_featured_image]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_image'
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'teach_kiddo_pro_theme_options[about_featured_image]',
		array(
		'label'       		=> esc_html__( 'Featured Image', 'teach-kiddo-pro' ),
		'section'     		=> 'teach_kiddo_pro_about_section',
		'active_callback'	=> 'teach_kiddo_pro_is_about_section_enable',
) ) );

// about image setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[about_video_image]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_image'
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'teach_kiddo_pro_theme_options[about_video_image]',
		array(
		'label'       		=> esc_html__( 'Video Featured Image', 'teach-kiddo-pro' ),
		'section'     		=> 'teach_kiddo_pro_about_section',
		'active_callback'	=> 'teach_kiddo_pro_is_about_section_enable',
) ) );

// about btn link setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[about_video_link]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[about_video_link]', array(
	'label'           	=> esc_html__( 'Youtube Video Link', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_about_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_about_section_enable',
	'type'				=> 'url',
) );
