<?php
/**
 * Client Section options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
// Add client Collection section
$wp_customize->add_section( 'teach_kiddo_pro_client_section', array(
    'title'             => esc_html__( 'Sponser','teach-kiddo-pro' ),
    'description'       => esc_html__( 'Sponser Section options.', 'teach-kiddo-pro' ),
    'panel'             => 'teach_kiddo_pro_front_page_panel',
    'active_callback'   => function( $control ) {
        return (
            teach_kiddo_pro_is_all_layout( $control )
            ||
            teach_kiddo_pro_is_second_layout( $control )
        );
    },
) );

// client content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[client_section_enable]', array(
    'default'           =>  $options['client_section_enable'],
    'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[client_section_enable]', array(
    'label'             => esc_html__( 'Sponser Section Enable', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_client_section',
    'on_off_label'      => teach_kiddo_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[client_section_enable]', array(
        'selector'            => '#sponsor-section .tooltiptext',
        'settings'            => 'teach_kiddo_pro_theme_options[client_section_enable]',
    ) );
}


$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[client_count]', array(
    'default'           => $options['client_count'],
    'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
    'validate_callback' => 'teach_kiddo_pro_validate_client_count',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[client_count]', array(
    'label'             => esc_html__( 'Number of Sponser', 'teach-kiddo-pro' ),
    'description'       => esc_html__( 'Note: Min 1 & Max 12. Please input the valid number and save. Then refresh the page to see the change.', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_client_section',
    'active_callback'   => 'teach_kiddo_pro_is_client_section_enable',
    'type'              => 'number',
    'input_attrs'       => array(
        'min'   => 1,
        'max'   => 12,
        'style' => 'width: 100px;'
        ),
) );

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[client_content_type]', array(
    'default'           => $options['client_content_type'],
    'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[client_content_type]', array(
    'label'             => esc_html__( 'Content Type', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_client_section',
    'type'              => 'select',
    'active_callback'   => 'teach_kiddo_pro_is_client_section_enable',
    'choices'           => array( 
        'page'          => esc_html__( 'Page', 'teach-kiddo-pro' ),
        'post'          => esc_html__( 'Post', 'teach-kiddo-pro' ),
        'category'          => esc_html__( 'Category', 'teach-kiddo-pro' ),
        'custom'        => esc_html__( 'Custom', 'teach-kiddo-pro' ),
    ),
) );

for ($i=1; $i <= $options['client_count'] ; $i++) :
    // client pages drop down chooser control and setting
    $wp_customize->add_setting( 'teach_kiddo_pro_theme_options[client_content_page_' . $i . ']', array(
        'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
    ) );

    $wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[client_content_page_' . $i . ']', array(
        'label'             => sprintf( esc_html__( 'Select Page %d', 'teach-kiddo-pro' ), $i ),
        'section'           => 'teach_kiddo_pro_client_section',
        'choices'           => teach_kiddo_pro_page_choices(),
        'active_callback'   => 'teach_kiddo_pro_is_client_section_content_page_enable',
    ) ) );

    // client posts drop down chooser control and setting
    $wp_customize->add_setting( 'teach_kiddo_pro_theme_options[client_content_post_' . $i . ']', array(
        'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
    ) );

    $wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[client_content_post_' . $i . ']', array(
        'label'             => sprintf( esc_html__( 'Select Post %d', 'teach-kiddo-pro' ), $i ),
        'section'           => 'teach_kiddo_pro_client_section',
        'choices'           => teach_kiddo_pro_post_choices(),
        'active_callback'   => 'teach_kiddo_pro_is_client_section_content_post_enable',
    ) ) );

    $wp_customize->add_setting( 'teach_kiddo_pro_theme_options[client_image_' . $i . ']', array(
        'sanitize_callback' => 'teach_kiddo_pro_sanitize_image',
    ) );

    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'teach_kiddo_pro_theme_options[client_image_' . $i . ']',
            array(
            'label'             => sprintf( esc_html__( 'Sponser Logo %d', 'teach-kiddo-pro' ), $i ),
            'section'           => 'teach_kiddo_pro_client_section',
            'active_callback'   => 'teach_kiddo_pro_is_client_section_content_custom_enable',
    ) ) );

    $wp_customize->add_setting( 'teach_kiddo_pro_theme_options[client_url_' . $i . ']', array(
        'sanitize_callback' => 'esc_url_raw',
    ) );

    $wp_customize->add_control( 'teach_kiddo_pro_theme_options[client_url_' . $i . ']', array(
        'label'             => sprintf( esc_html__( 'Sponser Url %d', 'teach-kiddo-pro' ), $i ),
        'section'           => 'teach_kiddo_pro_client_section',
        'active_callback'   => 'teach_kiddo_pro_is_client_section_content_custom_enable',
        'type'              => 'url',
    ) );


    $wp_customize->add_setting( 'teach_kiddo_pro_theme_options[client_hr_'. $i .']', array(
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    $wp_customize->add_control( new Teach_Kiddo_Pro_Customize_Horizontal_Line( $wp_customize, 'teach_kiddo_pro_theme_options[client_hr_'. $i .']',
        array(
            'section'           => 'teach_kiddo_pro_client_section',
            'active_callback'   => 'teach_kiddo_pro_is_client_section_enable',
            'type'            => 'hr'
    ) ) );

endfor;

$wp_customize->add_setting(  'teach_kiddo_pro_theme_options[client_content_category]', array(
    'sanitize_callback' => 'teach_kiddo_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Taxonomies_Control( $wp_customize,'teach_kiddo_pro_theme_options[client_content_category]', array(
    'label'             => esc_html__( 'Select Category', 'teach-kiddo-pro' ),
    'description'       => esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_client_section',
    'type'              => 'dropdown-taxonomies',
    'active_callback'   => 'teach_kiddo_pro_is_client_section_content_category_enable'
) ) );  