<?php
/**
 * contact Section options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add contact section
$wp_customize->add_section( 'teach_kiddo_pro_contact_section', array(
	'title'             => esc_html__( 'contacts','teach-kiddo-pro' ),
	'description'       => esc_html__( 'contacts Section options.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return (
            teach_kiddo_pro_is_default_layout( $control )
            ||
            teach_kiddo_pro_is_all_layout( $control )
            ||
            teach_kiddo_pro_is_second_layout( $control )
            ||
            teach_kiddo_pro_is_third_layout( $control )
        );
    },
) );

// contact content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[contact_section_enable]', array(
	'default'			=> 	$options['contact_section_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[contact_section_enable]', array(
	'label'             => esc_html__( 'contact Section Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_contact_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[contact_section_enable]', array(
        'selector'            => '#contact-section .tooltiptext',
        'settings'            => 'teach_kiddo_pro_theme_options[contact_section_enable]',
    ) );
}

// contact title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[contact_title_1]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'	=> $options['contact_title_1'],
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[contact_title_1]', array(
	'label'           	=>  esc_html__( 'Contact Title 1', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_contact_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_contact_section_enable',
	'type'				=> 'text',
) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[contact_title_1]', array(
        'selector'            => '#contact-section .section-header-wrapper .section-header h2',
        'settings'            => 'teach_kiddo_pro_theme_options[contact_title_1]',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
        'render_callback'     => 'teach_kiddo_pro_contact_title_1_partial',
    ) );
}


// contact title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[contact_title_2]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'	=> $options['contact_title_2'],
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[contact_title_2]', array(
	'label'           	=>  esc_html__( 'Contact Title 2', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_contact_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_contact_section_enable',
	'type'				=> 'text',
) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[contact_title_2]', array(
        'selector'            => '#contact-section .section-content .section-header h2',
        'settings'            => 'teach_kiddo_pro_theme_options[contact_title_2]',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
        'render_callback'     => 'teach_kiddo_pro_contact_title_2_partial',
    ) );
}

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[contact_phone_icon]', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Icon_Picker( $wp_customize, 'teach_kiddo_pro_theme_options[contact_phone_icon]', array(
	'label'             => esc_html__( 'Select Contact Icon', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_contact_section',
	'active_callback'	=> 'teach_kiddo_pro_is_contact_section_enable',
) ) );

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[contact_phone_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[contact_phone_label]', array(
	'label'           	=>  esc_html__( 'contact label', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_contact_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_contact_section_enable',
	'type'				=> 'text',
) );

// contact title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[contact_phone_number]', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[contact_phone_number]', array(
	'label'           	=>  esc_html__( 'Enter Contact Number', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_contact_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_contact_section_enable',
	'type'				=> 'text',
) );

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[contact_email_icon]', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Icon_Picker( $wp_customize, 'teach_kiddo_pro_theme_options[contact_email_icon]', array(
	'label'             => esc_html__( 'Select Email Icon', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_contact_section',
	'active_callback'	=> 'teach_kiddo_pro_is_contact_section_enable',
) ) );

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[contact_email_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[contact_email_label]', array(
	'label'           	=>  esc_html__( 'Email label', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_contact_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_contact_section_enable',
	'type'				=> 'text',
) );

// contact title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[contact_email_text]', array(
	'sanitize_callback' => 'sanitize_email',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[contact_email_text]', array(
	'label'           	=>  esc_html__( 'Enter Email', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_contact_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_contact_section_enable',
	'type'				=> 'email',
) );


$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[contact_location_icon]', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Icon_Picker( $wp_customize, 'teach_kiddo_pro_theme_options[contact_location_icon]', array(
	'label'             => esc_html__( 'Select location Icon', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_contact_section',
	'active_callback'	=> 'teach_kiddo_pro_is_contact_section_enable',
) ) );

// contact title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[contact_location_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[contact_location_label]', array(
	'label'           	=>  esc_html__( 'Location label', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_contact_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_contact_section_enable',
	'type'				=> 'text',
) );

// contact title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[contact_location_text]', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[contact_location_text]', array(
	'label'           	=>  esc_html__( 'Enter Location', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_contact_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_contact_section_enable',
	'type'				=> 'text',
) );


$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[contact_form_shortcode]', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[contact_form_shortcode]', array(
	'label'           	=>  esc_html__( 'Enter Form Shortcode', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_contact_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_contact_section_enable',
	'type'				=> 'text',
) );
