<?php
/**
 * Counter Section options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add Counter section
$wp_customize->add_section( 'teach_kiddo_pro_counter_section', array(
	'title'             => esc_html__( 'Counters','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Counters Section options.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return (
            teach_kiddo_pro_is_default_layout( $control )
            ||
            teach_kiddo_pro_is_all_layout( $control )
            ||
            teach_kiddo_pro_is_second_layout( $control )
        );
    },
) );

// Counter content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[counter_section_enable]', array(
	'default'			=> 	$options['counter_section_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[counter_section_enable]', array(
	'label'             => esc_html__( 'Counter Section Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_counter_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[counter_section_enable]', array(
        'selector'            => '#counter-section .tooltiptext',
        'settings'            => 'teach_kiddo_pro_theme_options[counter_section_enable]',
    ) );
}

// counter content type control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[counter_column]', array(
	'default'          	=> $options['counter_column'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[counter_column]', array(
	'label'             => esc_html__( 'Column Layout', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_counter_section',
	'type'				=> 'select',
	'active_callback' 	=> 'teach_kiddo_pro_is_counter_section_enable',
	'choices'			=> array( 
		'col-2'		=> esc_html__( 'Two Column', 'teach-kiddo-pro' ),
		'col-3'		=> esc_html__( 'Three Column', 'teach-kiddo-pro' ),
		'col-4'		=> esc_html__( 'Four Column', 'teach-kiddo-pro' ),
	),
) );

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[counter_image]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_image',
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'teach_kiddo_pro_theme_options[counter_image]',
		array(
		'label'       		=> esc_html__( 'Background Image', 'teach-kiddo-pro' ),
		'section'     		=> 'teach_kiddo_pro_counter_section',
		'active_callback'	=> 'teach_kiddo_pro_is_counter_section_enable',
) ) );


for ( $i = 1; $i <= 4; $i++ ) :

	// counter note control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[counter_content_icon_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Icon_Picker( $wp_customize, 'teach_kiddo_pro_theme_options[counter_content_icon_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Icon %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_counter_section',
		'active_callback'	=> 'teach_kiddo_pro_is_counter_section_enable',
	) ) );

	// counter title setting and control
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[counter_title_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'teach_kiddo_pro_theme_options[counter_title_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Counter Title %d', 'teach-kiddo-pro' ), $i ),
		'section'        	=> 'teach_kiddo_pro_counter_section',
		'active_callback' 	=> 'teach_kiddo_pro_is_counter_section_enable',
		'type'				=> 'text',
	) );

	// counter title setting and control
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[counter_number_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'teach_kiddo_pro_theme_options[counter_number_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Counter Count %d', 'teach-kiddo-pro' ), $i ),
		'section'        	=> 'teach_kiddo_pro_counter_section',
		'active_callback' 	=> 'teach_kiddo_pro_is_counter_section_enable',
		'type'				=> 'text',
	) );

	// counter hr setting and control
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[counter_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Customize_Horizontal_Line( $wp_customize, 'teach_kiddo_pro_theme_options[counter_hr_'. $i .']',
		array(
			'section'         => 'teach_kiddo_pro_counter_section',
			'active_callback' => 'teach_kiddo_pro_is_counter_section_enable',
			'type'			  => 'hr'
	) ) );
endfor;