<?php
/**
 * Courses Section options
 *
 * @package Theme Palace
 * @subpackage Educollege Pro
 * @since Educollege Pro 1.0.0
 */

// Add Courses section
$wp_customize->add_section( 'teach_kiddo_pro_featured_course_section', array(
	'title'             => esc_html__( 'Featured Courses','teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return (
            teach_kiddo_pro_is_default_layout( $control )
            ||
            teach_kiddo_pro_is_all_layout( $control )
    	);
    }
) );

// Courses content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_course_section_enable]', array(
	'default'			=> 	$options['featured_course_section_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[featured_course_section_enable]', array(
	'label'             => esc_html__( 'Featured Section Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_featured_course_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[featured_course_section_enable]', array(
		'selector'            => '#featured-courses .tooltiptext',
		'settings'            => 'teach_kiddo_pro_theme_options[featured_course_section_enable]',
    ) );
}

// course title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_course_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['featured_course_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[featured_course_title]', array(
	'label'           	=> esc_html__( 'Title', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_featured_course_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_featured_course_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[featured_course_title]', array(
		'selector'            => '#featured-courses .section-header h2',
		'settings'            => 'teach_kiddo_pro_theme_options[featured_course_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_featured_course_title_partial',
    ) );
}

// course btn title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_course_read_more]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['featured_course_read_more'],
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[featured_course_read_more]', array(
	'label'           	=> esc_html__( 'Read More Label', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_featured_course_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_featured_course_section_enable',
	'type'				=> 'text',
) );

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_estemate_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['featured_estemate_label'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[featured_estemate_label]', array(
	'label'           	=> esc_html__( 'Estimate Time Lable', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_featured_course_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_featured_course_section_enable',
	'type'				=> 'text',
) );

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_starts_on_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['featured_starts_on_label'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[featured_starts_on_label]', array(
	'label'           	=> esc_html__( 'Enroll Now Lable', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_featured_course_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_featured_course_section_enable',
	'type'				=> 'text',
) );

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_rating_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['featured_rating_label'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[featured_rating_label]', array(
	'label'           	=> esc_html__( 'Rating Lable', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_featured_course_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_featured_course_section_enable',
	'type'				=> 'text',
) );


// Event social icons number control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_course_count]', array(
	'default'          	=> $options['featured_course_count'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
	'validate_callback' => 'teach_kiddo_pro_validate_course_count',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[featured_course_count]', array(
	'label'             => esc_html__( 'Number of Courses', 'teach-kiddo-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 12. Please input the valid number and save. Then refresh the page to see the change.', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_featured_course_section',
	'active_callback'   => 'teach_kiddo_pro_is_featured_course_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 12,
		'style' => 'width: 100px;'
		),
) );

// Courses content type control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_course_content_type]', array(
	'default'          	=> $options['featured_course_content_type'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[featured_course_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_featured_course_section',
	'type'				=> 'select',
	'active_callback' 	=> 'teach_kiddo_pro_is_featured_course_section_enable',
	'choices'			=> teach_kiddo_pro_popular_course_content_type(),
) );

for ( $i = 1; $i <= $options['featured_course_count']; $i++ ) :

	// course pages drop down chooser control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_course_content_page_' . $i . ']', array(
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[featured_course_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_featured_course_section',
		'choices'			=> teach_kiddo_pro_page_choices(),
		'active_callback'	=> 'teach_kiddo_pro_is_featured_course_section_content_page_enable',
	) ) );	

	if ( class_exists( 'TP_Education' ) ) {
		// course pages drop down chooser control and setting
		$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_course_content_course_' . $i . ']', array(
			'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
		) );

		$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[featured_course_content_course_' . $i . ']', array(
			'label'             => sprintf( esc_html__( 'Select Course %d', 'teach-kiddo-pro' ), $i ),
			'section'           => 'teach_kiddo_pro_featured_course_section',
			'choices'			=> teach_kiddo_pro_course_choices(),
			'active_callback'	=> 'teach_kiddo_pro_is_featured_course_section_content_course_enable',
		) ) );		
	}

	
	// course posts drop down chooser control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_course_content_post_' . $i . ']', array(
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[featured_course_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_featured_course_section',
		'choices'			=> teach_kiddo_pro_post_choices(),
		'active_callback'	=> 'teach_kiddo_pro_is_featured_course_section_content_post_enable',
	) ) );

	// course hr setting and control
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_course_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Customize_Horizontal_Line( $wp_customize, 'teach_kiddo_pro_theme_options[featured_course_hr_'. $i .']',
		array(
			'section'         => 'teach_kiddo_pro_featured_course_section',
			'type'			  => 'hr'
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'teach_kiddo_pro_theme_options[featured_course_content_course_category]', array(
	'sanitize_callback' => 'absint',
) ) ;

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Taxonomies_Control( $wp_customize,'teach_kiddo_pro_theme_options[featured_course_content_course_category]', array(
	'label'             => esc_html__( 'Select Course Category', 'teach-kiddo-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_featured_course_section',
	'type'              => 'dropdown-taxonomies',
	'taxonomy'          => 'tp-course-category',
	'active_callback'	=> 'teach_kiddo_pro_is_featured_course_section_content_course_category_enable'
) ) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'teach_kiddo_pro_theme_options[featured_course_content_category]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Taxonomies_Control( $wp_customize,'teach_kiddo_pro_theme_options[featured_course_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'teach-kiddo-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_featured_course_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'teach_kiddo_pro_is_featured_course_section_content_category_enable'
) ) );

