<?php
/**
 * Featured Posts Section options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add Featured Posts section
$wp_customize->add_section( 'teach_kiddo_pro_featured_posts_section', array(
	'title'             => esc_html__( 'Featured Posts ','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Featured Posts Section options.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return (
            teach_kiddo_pro_is_all_layout( $control )
            ||
            teach_kiddo_pro_is_fourth_layout( $control )
        );
    },
) );

// Featured Posts content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_posts_section_enable]', array(
	'default'			=> 	$options['featured_posts_section_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[featured_posts_section_enable]', array(
	'label'             => esc_html__( 'Featured Posts Section Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_featured_posts_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[featured_posts_section_enable]', array(
		'selector'            => '#featured-posts-section .tooltiptext',
		'settings'            => 'teach_kiddo_pro_theme_options[featured_posts_section_enable]',
    ) );
}

// Event social icons number control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_posts_count]', array(
	'default'          	=> $options['featured_posts_count'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
	'validate_callback' => 'teach_kiddo_pro_validate_featured_posts_count',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[featured_posts_count]', array(
	'label'             => esc_html__( 'Number of Posts', 'teach-kiddo-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 50. Please input the valid number and save. Then refresh the page to see the change.', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_featured_posts_section',
	'active_callback'   => 'teach_kiddo_pro_is_featured_posts_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 50,
		'style' => 'width: 100px;'
		),
) );

// Featured Posts content type control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_posts_col_layout]', array(
	'default'          	=> $options['featured_posts_col_layout'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[featured_posts_col_layout]', array(
	'label'             => esc_html__( 'Content Type', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_featured_posts_section',
	'type'				=> 'select',
	'active_callback' 	=> 'teach_kiddo_pro_is_featured_posts_section_enable',
	'choices'			=> array( 
		'col-2' 		=> esc_html__( 'Column Two', 'teach-kiddo-pro' ),
		'col-3' 		=> esc_html__( 'Column Three', 'teach-kiddo-pro' ),
		'col-4' 		=> esc_html__( 'Column Four', 'teach-kiddo-pro' ),
	),
) );

// Featured Posts content type control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_posts_content_type]', array(
	'default'          	=> $options['featured_posts_content_type'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[featured_posts_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_featured_posts_section',
	'type'				=> 'select',
	'active_callback' 	=> 'teach_kiddo_pro_is_featured_posts_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'teach-kiddo-pro' ),
		'post' 		=> esc_html__( 'Post', 'teach-kiddo-pro' ),
		'category' 	=> esc_html__( 'Category', 'teach-kiddo-pro' ),
	),
) );


for ( $i = 1; $i <= $options['featured_posts_count']; $i++ ) :

	// blog pages drop down chooser control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_posts_content_page_' . $i . ']', array(
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[featured_posts_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_featured_posts_section',
		'choices'			=> teach_kiddo_pro_page_choices(),
		'active_callback'	=> 'teach_kiddo_pro_is_featured_posts_section_content_page_enable',
	) ) );

	// blog posts drop down chooser control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[featured_posts_content_post_' . $i . ']', array(
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[featured_posts_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_featured_posts_section',
		'choices'			=> teach_kiddo_pro_post_choices(),
		'active_callback'	=> 'teach_kiddo_pro_is_featured_posts_section_content_post_enable',
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'teach_kiddo_pro_theme_options[featured_posts_content_category]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Taxonomies_Control( $wp_customize,'teach_kiddo_pro_theme_options[featured_posts_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'teach-kiddo-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_featured_posts_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'teach_kiddo_pro_is_featured_posts_section_content_category_enable'
) ) );