<?php
/**
 * Gallery Section options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add Gallery section
$wp_customize->add_section( 'teach_kiddo_pro_gallery_section', array(
	'title'             => esc_html__( 'Gallery','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Gallery Section options.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return (
            teach_kiddo_pro_is_default_layout( $control )
            ||
            teach_kiddo_pro_is_second_layout( $control )
            ||
            teach_kiddo_pro_is_all_layout( $control )
        );
    },
) );

// Gallery content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[gallery_section_enable]', array(
	'default'			=> 	$options['gallery_section_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[gallery_section_enable]', array(
	'label'             => esc_html__( 'Gallery Section Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_gallery_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[gallery_section_enable]', array(
		'selector'            => '#gallery-section .tooltiptext',
		'settings'            => 'teach_kiddo_pro_theme_options[gallery_section_enable]',
    ) );
}

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[gallery_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['gallery_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[gallery_title]', array(
	'label'           	=> esc_html__( 'Gallery Title', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_gallery_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_gallery_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[gallery_title]', array(
		'selector'            => '#gallery-section h2.section-title',
		'settings'            => 'teach_kiddo_pro_theme_options[gallery_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_gallery_title_partial',
    ) );
}

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[gallery_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['gallery_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[gallery_btn_title]', array(
	'label'           	=> esc_html__( 'Btn Label', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_gallery_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_gallery_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[gallery_btn_title]', array(
		'selector'            => '#gallery-section .read-more a',
		'settings'            => 'teach_kiddo_pro_theme_options[gallery_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_gallery_btn_title_partial',
    ) );
}

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[gallery_btn_url]', array(
	'sanitize_callback' => 'esc_url_raw',
	'default'			=> $options['gallery_btn_url'],
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[gallery_btn_url]', array(
	'label'           	=> esc_html__( 'Btn url', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_gallery_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_gallery_section_enable',
	'type'				=> 'url',
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[gallery_count]', array(
	'default'          	=> $options['gallery_count'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
	'validate_callback' => 'teach_kiddo_pro_validate_gallery_count',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[gallery_count]', array(
	'label'             => esc_html__( 'Number of Slides', 'teach-kiddo-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 50. Please input the valid number and save. Then refresh the page to see the change.', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_gallery_section',
	'active_callback'   => 'teach_kiddo_pro_is_gallery_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 50,
		'style' => 'width: 100px;'
		),
) );

// Gallery content type control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[gallery_content_type]', array(
	'default'          	=> $options['gallery_content_type'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[gallery_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_gallery_section',
	'type'				=> 'select',
	'active_callback' 	=> 'teach_kiddo_pro_is_gallery_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'teach-kiddo-pro' ),
		'post' 		=> esc_html__( 'Post', 'teach-kiddo-pro' ),
		'category' 	=> esc_html__( 'Category', 'teach-kiddo-pro' ),
	),
) );

for ( $i = 1; $i <= $options['gallery_count']; $i++ ) :
	// slider pages drop down chooser control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[gallery_content_page_' . $i . ']', array(
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[gallery_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_gallery_section',
		'choices'			=> teach_kiddo_pro_page_choices(),
		'active_callback'	=> 'teach_kiddo_pro_is_gallery_section_content_page_enable',
	) ) );

	// slider posts drop down chooser control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[gallery_content_post_' . $i . ']', array(
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[gallery_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_gallery_section',
		'choices'			=> teach_kiddo_pro_post_choices(),
		'active_callback'	=> 'teach_kiddo_pro_is_gallery_section_content_post_enable',
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'teach_kiddo_pro_theme_options[gallery_content_category]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Taxonomies_Control( $wp_customize,'teach_kiddo_pro_theme_options[gallery_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'teach-kiddo-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_gallery_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'teach_kiddo_pro_is_gallery_section_content_category_enable'
) ) );