<?php 

$wp_customize->add_section( 'teach_kiddo_pro_home_layout', array(
	'title'             => esc_html__( 'Home Page Layout','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Home Page Layout option.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_front_page_panel',
) );


$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[home_layout]', array(
		'default'           => $options['home_layout'],
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
		'transport'			=> 'refresh'
	) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[home_layout]', array(
	'type'				=> 'radio',
	'label'             => esc_html__( 'Select Homepage layout', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_home_layout',
	'choices'				 => array( 
		'all-design'     		=> esc_html__( 'All Section', 'teach-kiddo-pro' ),
		'default-design'     	=> esc_html__( 'Default Design', 'teach-kiddo-pro' ),
		'second-design'      	=> esc_html__( 'Business Design', 'teach-kiddo-pro' ),
		'third-design'      	=> esc_html__( 'Shop Design', 'teach-kiddo-pro' ),
		'fourth-design'       	=> esc_html__( 'Blog Design', 'teach-kiddo-pro' ),
		)
) );

foreach ( array( 'all', 'default', 'second', 'third', 'fourth' ) as $list) {
	// Site layout setting and control.
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options['.$list.'_sortable]', array(
		'default'			  => $options[$list.'_sortable'],
		'sanitize_callback'   => 'teach_kiddo_pro_sanitize_sortable',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Customize_Sortable_Control ( $wp_customize, 'teach_kiddo_pro_theme_options['.$list.'_sortable]', array(
		'label'               => esc_html__( 'Sortable Homepage', 'teach-kiddo-pro' ),
		'description'         => esc_html__( 'Drag and Drop to sort the sections according to your preference.', 'teach-kiddo-pro' ),
		'section'             => 'teach_kiddo_pro_home_layout',
		'type'                => 'sortable',
		'choices'			  => teach_kiddo_pro_sortable_sections(),
		'active_callback'	  => 'teach_kiddo_pro_is_'.$list.'_layout'

	) ) );
}