<?php
/**
 * Instagram Section options
 *
 * @package Theme Palace
 * @subpackage Fondness Pro
 * @since Fondness Pro 1.0.0
 */

// Add Instagram section
$wp_customize->add_section( 'teach_kiddo_pro_instagram_section', array(
	'title'             => esc_html__( 'Instagram','teach-kiddo-pro' ),
	'description'       => sprintf( teach_kiddo_pro_santize_allow_tag('Instagram Section options. <a href="%1$s">click here </a> to link instagram account', 'teach-kiddo-pro'), admin_url( $paths = '?page=sb-instagram-feed', $scheme = 'admin' ) ),
	'panel'             => 'teach_kiddo_pro_front_page_panel',
	'active_callback'	=>  function( $control ) {
        return ( 
        	teach_kiddo_pro_is_fourth_layout( $control )
            ||
            teach_kiddo_pro_is_all_layout( $control )
        );
    },
) );

// Instagram content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[instagram_section_enable]', array(
	'default'			=> 	$options['instagram_section_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[instagram_section_enable]', array(
	'label'             => esc_html__( 'Instagram Section Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_instagram_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[instagram_section_enable]', array(
		'selector'            => '#instagram .tooltiptext',
		'settings'            => 'teach_kiddo_pro_theme_options[instagram_section_enable]',
    ) );
}

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[instagram_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['instagram_title'],
	'transport'			=> 'postMessage',
	) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[instagram_title]', array(
	'label'           	=> esc_html__( 'Title', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_blog_section',
	'type'				=> 'text',
) );