<?php
/**
 * latest_products Section options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

if ( !class_exists('WooCommerce') ) {
    return;
}

// Add latest_products section
$wp_customize->add_section( 'teach_kiddo_pro_latest_products_section', array(
	'title'             => esc_html__( 'Latest Products','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Note: To activate this section you need to install WooCommerce Plugin.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return ( 
        	teach_kiddo_pro_is_all_layout( $control )
        	||
        	teach_kiddo_pro_is_third_layout( $control )
        );
    },
) );

// latest_products content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[latest_products_section_enable]', array(
	'default'			=> 	$options['latest_products_section_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[latest_products_section_enable]', array(
	'label'             => esc_html__( 'Latest Products Section Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_latest_products_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[latest_products_section_enable]', array(
		'selector'            => '#latest-products .tooltiptext',
		'settings'            => 'teach_kiddo_pro_theme_options[latest_products_section_enable]',
    ) );
}

// Servuce count number control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[latest_products_count]', array(
	'default'          	=> $options['latest_products_count'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
	'validate_callback' => 'teach_kiddo_pro_validate_latest_products_count',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[latest_products_count]', array(
	'label'             => esc_html__( 'Number of Featured Productss Posts', 'teach-kiddo-pro' ),
	'description'       => esc_html__( 'Note: Min 2 & Max 50. Please input the valid number and save. Then refresh the page to see the change.', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_latest_products_section',
	'active_callback'   => 'teach_kiddo_pro_is_latest_products_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 2,
		'max'	=> 50,
		'style' => 'width: 100px;'
		),
) );

for ( $i = 1; $i <= $options['latest_products_count']; $i++ ) :

	// Add dropdown category setting and control.
	$wp_customize->add_setting(  'teach_kiddo_pro_theme_options[latest_products_content_latest_products_category_'.$i.']', array(
		'sanitize_callback' => 'absint',
		) ) ;

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Taxonomies_Control( $wp_customize,'teach_kiddo_pro_theme_options[latest_products_content_latest_products_category_'.$i.']', array(
	'label'             => sprintf( esc_html__( 'Select Featured Products Category %d', 'teach-kiddo-pro' ), $i ),
	'section'           => 'teach_kiddo_pro_latest_products_section',
	'taxonomy'			=> 'product_cat',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'teach_kiddo_pro_is_latest_products_section_enable'
	) ) );
endfor;