<?php
/**
 * Popular Posts Section options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add Popular Posts section
$wp_customize->add_section( 'teach_kiddo_pro_popular_posts_section', array(
	'title'             => esc_html__( 'Popular Posts','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Popular Posts Section options.', 'teach-kiddo-pro' ),
	'panel'				=> 'teach_kiddo_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return (
            teach_kiddo_pro_is_fourth_layout( $control )
            ||
            teach_kiddo_pro_is_all_layout( $control )
        );
    },

) );

// Popular Posts content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[popular_posts_section_enable]', array(
	'default'			=> 	$options['popular_posts_section_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[popular_posts_section_enable]', array(
	'label'             => esc_html__( 'Popular Posts Section Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_popular_posts_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[popular_posts_section_enable]', array(
		'selector'            => '#featured-posts-section .tooltiptext',
		'settings'            => 'teach_kiddo_pro_theme_options[popular_posts_section_enable]',
    ) );
}

// Popular Posts btn label setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[popular_posts_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['popular_posts_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[popular_posts_title]', array(
	'label'           	=> esc_html__( 'Section Title', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_popular_posts_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_popular_posts_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[popular_posts_title]', array(
		'selector'            => '#featured-posts-section h2.section-title',
		'settings'            => 'teach_kiddo_pro_theme_options[popular_posts_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_popular_posts_title_partial',
    ) );
}


// content type control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[popular_posts_count]', array(
	'default'          	=> $options['popular_posts_count'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
	'validate_callback' => 'teach_kiddo_pro_validate_popular_posts_count',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[popular_posts_count]', array(
	'label'             => esc_html__( 'Number of Posts', 'teach-kiddo-pro' ),
	'description'       => esc_html__( 'Note: Min 3 & Max 30. Please input the valid number and save. Then refresh the page to see the change.', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_popular_posts_section',
	'active_callback'   => 'teach_kiddo_pro_is_popular_posts_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 3,
		'max'	=> 30,
		'style' => 'width: 100px;'
		),
) );

// long Excerpt length setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[popular_posts_excerpt_length]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
	'validate_callback' => 'teach_kiddo_pro_validate_long_excerpt',
	'default'			=> $options['popular_posts_excerpt_length'],
	) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[popular_posts_excerpt_length]', array(
	'label'       		=> esc_html__( 'Blog Excerpt Length', 'teach-kiddo-pro' ),
	'description' 		=> esc_html__( 'Total description words to be displayed in popular_posts posts.', 'teach-kiddo-pro' ),
	'section'     		=> 'teach_kiddo_pro_popular_posts_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_popular_posts_section_enable',
	'type'        		=> 'number',
	'input_attrs' 		=> array(
		'style'       => 'width: 80px;',
		'max'         => 100,
		'min'         => 5,
		),
	) );

// Popular Posts content type control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[popular_posts_content_type]', array(
	'default'          	=> $options['popular_posts_content_type'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[popular_posts_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_popular_posts_section',
	'type'				=> 'select',
	'active_callback' 	=> 'teach_kiddo_pro_is_popular_posts_section_enable',
	'choices'			=> array(
		'page'      => esc_html__( 'Page', 'teach-kiddo-pro' ),
		'post'      => esc_html__( 'Post', 'teach-kiddo-pro' ),
		'category'  => esc_html__( 'Category', 'teach-kiddo-pro' ),
		),
) );

for ( $i = 1; $i <= $options['popular_posts_count']; $i++ ) :
	// popular_posts pages drop down chooser control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[popular_posts_content_page_' . $i . ']', array(
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[popular_posts_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_popular_posts_section',
		'choices'			=> teach_kiddo_pro_page_choices(),
		'active_callback'	=> 'teach_kiddo_pro_is_popular_posts_section_content_page_enable',
	) ) );

	// popular_posts posts drop down chooser control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[popular_posts_content_post_' . $i . ']', array(
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[popular_posts_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_popular_posts_section',
		'choices'			=> teach_kiddo_pro_post_choices(),
		'active_callback'	=> 'teach_kiddo_pro_is_popular_posts_section_content_post_enable',
	) ) );

endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'teach_kiddo_pro_theme_options[popular_posts_content_category]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Taxonomies_Control( $wp_customize,'teach_kiddo_pro_theme_options[popular_posts_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'teach-kiddo-pro' ),
	'description'      	=> esc_html__( 'Note: Popular selected no of posts will be shown from selected category', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_popular_posts_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'teach_kiddo_pro_is_popular_posts_section_content_category_enable'
) ) );